/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sexec.naming.tree;

import java.util.Objects;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

public class ShortString {
    protected String originalString;
    @Accessors
    private int costFactor = 1;
    protected int[] cutArray;
    protected int[] previous_cutArray;
    public static final int COST_LOWERCASE_VOCALS = 1;
    public static final int COST_UNDERSCORE = 1;
    public static final int COST_LOWERCASE_CONSONANTS = 2;
    public static final int COST_UPPERCASE = 3;
    public static final int COST_DIGIT = 10;
    public static final int COST_FIRSTLETTER = 10;

    public ShortString(String s) {
        this(s, 1);
    }

    public ShortString(String s, int factor) {
        this.originalString = s == null ? "" : s;
        this.cutArray = new int[this.size()];
        this.previous_cutArray = new int[this.size()];
        this.reset();
        this.saveCurrentToPrevious();
        this.costFactor = factor;
    }

    public String getOriginalString() {
        return this.originalString;
    }

    protected int size() {
        return this.originalString.length();
    }

    public void reset() {
        this.saveCurrentToPrevious();
        int i = 0;
        while (i < this.size()) {
            this.cutArray[i] = 1;
            ++i;
        }
    }

    protected void saveCurrentToPrevious() {
        int i = 0;
        while (i < this.size()) {
            this.previous_cutArray[i] = this.cutArray[i];
            ++i;
        }
    }

    public void rollback() {
        int i = 0;
        while (i < this.size()) {
            this.cutArray[i] = this.previous_cutArray[i];
            ++i;
        }
    }

    public String toString() {
        return this.getShortenedString();
    }

    public String getShortenedString() {
        String _xblockexpression = null;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.size()) {
            boolean _notEquals;
            int _get = this.cutArray[i];
            boolean bl = _notEquals = _get != 0;
            if (_notEquals) {
                sb.append(this.originalString.charAt(i));
            }
            ++i;
        }
        _xblockexpression = sb.toString();
        return _xblockexpression;
    }

    public int getShortenedSize() {
        int length = 0;
        int i = 0;
        while (i < this.size()) {
            boolean _notEquals;
            int _get = this.cutArray[i];
            boolean bl = _notEquals = _get != 0;
            if (_notEquals) {
                int _length = length;
                length = _length + 1;
            }
            ++i;
        }
        return length;
    }

    public int getCutRatioFactor() {
        float _cutRatio = this.getCutRatio();
        float _multiply = _cutRatio * 10.0f;
        return 10 + (int)_multiply;
    }

    public int getCutCost() {
        boolean _lessThan;
        float _cutRatio = this.getCutRatio();
        double _minus = 1.0 - (double)_cutRatio;
        boolean bl = _lessThan = _minus < 0.001;
        if (_lessThan) {
            return Integer.MAX_VALUE;
        }
        int cost = 0;
        int i = 0;
        while (i < this.size()) {
            boolean _equals;
            int _get = this.cutArray[i];
            boolean bl2 = _equals = _get == 0;
            if (_equals) {
                int _cost = cost;
                int _baseCutCost = this.getBaseCutCost(i);
                cost = _cost + _baseCutCost;
            }
            ++i;
        }
        int _cutRatioFactor = this.getCutRatioFactor();
        int _multiply = cost * _cutRatioFactor;
        return _multiply * this.costFactor;
    }

    public int getBaseCutCost(int index) {
        boolean _isDigit;
        int cost = 0;
        char c = this.originalString.charAt(index);
        if (index == 0) {
            int _cost = cost;
            cost = _cost + 10;
        }
        if (_isDigit = Character.isDigit(c)) {
            int _cost_1 = cost;
            cost = _cost_1 + 10;
        } else {
            boolean _isUpperCase = Character.isUpperCase(c);
            if (_isUpperCase) {
                int _cost_2 = cost;
                cost = _cost_2 + 3;
            } else {
                boolean _isLowercaseVocal = this.isLowercaseVocal(c);
                if (_isLowercaseVocal) {
                    int _cost_3 = cost;
                    cost = _cost_3 + 1;
                } else {
                    boolean _equals = Character.valueOf(c).toString().equals("_");
                    if (_equals) {
                        int _cost_4 = cost;
                        cost = _cost_4 + 1;
                    } else {
                        int _cost_5 = cost;
                        cost = _cost_5 + 2;
                    }
                }
            }
        }
        return cost;
    }

    public int removeCheapestChar() {
        int _xblockexpression = 0;
        int cheapestOperation_cost = Integer.MAX_VALUE;
        int cheapestOperation_index = 0;
        int i = 0;
        while (i < this.size()) {
            int cost;
            boolean _notEquals;
            int _get = this.cutArray[i];
            boolean bl = _notEquals = _get != 0;
            if (_notEquals && (cost = this.getBaseCutCost(i)) < cheapestOperation_cost) {
                cheapestOperation_cost = cost;
                cheapestOperation_index = i;
            }
            ++i;
        }
        _xblockexpression = this.removeIndex(cheapestOperation_index);
        return _xblockexpression;
    }

    public float getCutRatio() {
        int _shortenedSize = this.getShortenedSize();
        int _size = this.size();
        float _divide = (float)_shortenedSize / (float)_size;
        return 1.0f - _divide;
    }

    public int removeIndex(int index) {
        boolean _lessThan;
        int _xblockexpression = 0;
        this.saveCurrentToPrevious();
        int _xifexpression = 0;
        int _size = this.size();
        boolean bl = _lessThan = index < _size;
        if (_lessThan) {
            this.cutArray[index] = 0;
            _xifexpression = 0;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected boolean isLowercaseVocal(int i) {
        char c = this.originalString.charAt(i);
        return this.isLowercaseVocal(c);
    }

    protected boolean isLowercaseVocal(char c) {
        String s = Character.valueOf(c).toString();
        return Objects.equals(s, "a") || Objects.equals(s, "e") || Objects.equals(s, "i") || Objects.equals(s, "o") || Objects.equals(s, "u");
    }

    @Pure
    public int getCostFactor() {
        return this.costFactor;
    }

    public void setCostFactor(int costFactor) {
        this.costFactor = costFactor;
    }
}

