/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui;

import com.yakindu.sct.license.LicenseChecker;
import com.yakindu.sct.license.LicenseStatus;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TrialChecker
implements IStartup {
    public static final String URL_PARAMS = "?utm_campaign=YAKINDU%20Statechart%20Tools&utm_source=Statechart%20Tools";
    public static final String WELCOME_URL = "https://www.itemis.com/en/yakindu/state-machine/welcome/?utm_campaign=YAKINDU%20Statechart%20Tools&utm_source=Statechart%20Tools";
    public static final String TRIAL_EXPIRED = "https://www.itemis.com/en/yakindu/state-machine/licenses/?utm_campaign=YAKINDU%20Statechart%20Tools&utm_source=Statechart%20Tools";
    public static final String PRODUCT_ID = "com.yakindu.sct.products.full.product";

    public void earlyStartup() {
        if (!this.isProduct()) {
            return;
        }
        LicenseStatus status = new LicenseChecker().checkStandardLicense();
        if (status.getStatus() == LicenseStatus.Status.DISABLED) {
            return;
        }
        if (status.isTrial()) {
            this.openExternalBrowser(WELCOME_URL);
        } else if (!status.isValidOrTrial()) {
            this.openExternalBrowser(TRIAL_EXPIRED);
        }
    }

    protected void openExternalBrowser(String url) {
        if (this.online()) {
            try {
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url));
            }
            catch (MalformedURLException | PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean online() {
        block12: {
            Throwable throwable = null;
            Object var2_4 = null;
            Socket socket = new Socket();
            try {
                InetSocketAddress socketAddress = new InetSocketAddress("itemis.com", 80);
                socket.connect(socketAddress, 500);
                socket.close();
                if (socket == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException unknownHost) {
                    return false;
                }
            }
            socket.close();
        }
        return true;
    }

    protected boolean isProduct() {
        return Platform.getProduct().getId().equals(PRODUCT_ID);
    }
}

