/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.install;

import com.yakindu.sct.ui.install.ProvisioningAgentProvider;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.query.QueryUtil;

public class InstallationChecker {
    private ProvisioningAgentProvider agentProvider = new ProvisioningAgentProvider();

    public boolean isFeatureInstalled(String featureId) {
        IProvisioningAgent agent = null;
        try {
            agent = this.agentProvider.get();
            IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
            IProfile selfProfile = profileRegistry.getProfile("_SELF_");
            if (selfProfile == null) {
                return true;
            }
            Set installed = selfProfile.available(QueryUtil.createIUQuery((String)featureId), (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet();
            boolean bl = !installed.isEmpty();
            return bl;
        }
        catch (ProvisionException e) {
            e.printStackTrace();
        }
        finally {
            if (agent != null) {
                agent.stop();
            }
        }
        return false;
    }

    public boolean isAllFeaturesInstalled(Iterable<String> featureIDs) {
        IProvisioningAgent agent = null;
        try {
            agent = this.agentProvider.get();
            IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
            IProfile selfProfile = profileRegistry.getProfile("_SELF_");
            if (selfProfile == null) {
                return true;
            }
            for (String featureId : featureIDs) {
                Set installed = selfProfile.available(QueryUtil.createIUQuery((String)featureId), (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet();
                if (!installed.isEmpty()) continue;
                return false;
            }
            return true;
        }
        catch (ProvisionException e) {
            e.printStackTrace();
        }
        finally {
            if (agent != null) {
                agent.stop();
            }
        }
        return false;
    }
}

