/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.wizards;

import com.yakindu.sct.runtime.ContentTypeHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class WorkspaceTreeContentProvider
implements ITreeContentProvider {
    protected String contentType;

    public WorkspaceTreeContentProvider() {
    }

    public WorkspaceTreeContentProvider(String contentType) {
        this.contentType = contentType;
    }

    public Object[] getElements(Object inputElement) {
        try {
            if (inputElement instanceof IContainer) {
                return this.filterForContent(((IContainer)inputElement).members());
            }
            if (inputElement instanceof Object[]) {
                return this.filterForContent((Object[])inputElement);
            }
            if (inputElement instanceof Collection) {
                return this.filterForContent(((Collection)inputElement).toArray());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        return element instanceof IContainer;
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public Object[] filterForContent(Object[] inputElements) {
        List<Object> list = Arrays.asList(inputElements);
        List<IResource> result = list.stream().filter(m -> this.isRelevant(m)).collect(Collectors.toList());
        return result.toArray(new IResource[result.size()]);
    }

    public boolean containsFile(IContainer folder) {
        try {
            List<IResource> list = Arrays.asList(folder.members());
            return list.stream().anyMatch(m -> this.isRelevant(m));
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isRelevant(Object member) {
        if (member instanceof IFile && this.hasContentType((IFile)member)) {
            return true;
        }
        return member instanceof IContainer && this.containsFile((IContainer)member);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object getParent(Object element) {
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean hasContentType(IFile res) {
        if (this.contentType == null) {
            return false;
        }
        IContentType contentType = ContentTypeHelper.getContentType((IFile)res);
        if (contentType == null) {
            return false;
        }
        return this.contentType.equals(contentType.getId());
    }
}

