/*
 * Decompiled with CFR 0.152.
 */
package com.xformation.lmx;

import com.xformation.lmx.LmxException;
import com.xformation.lmx.LmxHostidType;
import com.xformation.lmx.LmxSettings;
import com.xformation.lmx.LmxStatus;

public class LmxAdmin {
    private long[] lmxHandle = new long[]{0L};

    public LmxAdmin() {
        this.lmxHandle[0] = 0L;
    }

    private native int jniCInit(long[] var1);

    private native void jniCFree(long var1);

    private native int jniCSetOptionInt(long var1, LmxSettings var3, int var4);

    private native int jniCSetOptionStr(long var1, LmxSettings var3, String var4);

    private native int jniCSetOptionEnumHostidType(long var1, LmxSettings var3, LmxHostidType var4);

    private native int jniCAdminReserve(long var1, String var3, int var4, int var5, int var6, int var7, String var8);

    private native int jniCAdminReserveEarlyReturn(long var1, String var3, String var4);

    private native int jniCAdminUploadLicense(long var1, String var3, String var4);

    private native int jniCAdminRestartServer(long var1, String var3, int var4, String var5);

    private native int jniCAdminShutdownServer(long var1, String var3, int var4, String var5);

    public void init() throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCInit(this.lmxHandle));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void free() {
        this.jniCFree(this.lmxHandle[0]);
        this.lmxHandle[0] = 0L;
    }

    public void setOption(LmxSettings setting, String strOption) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCSetOptionStr(this.lmxHandle[0], setting, strOption));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void setOption(LmxSettings setting, int option) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCSetOptionInt(this.lmxHandle[0], setting, option));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void setOption(LmxSettings setting, boolean option) throws LmxException {
        this.setOption(setting, option ? 1 : 0);
    }

    public void setOption(LmxSettings setting, LmxHostidType option) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCSetOptionEnumHostidType(this.lmxHandle[0], setting, option));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void reserve(String featureName, int majorVer, int minorVer, int count, int duration, String token) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCAdminReserve(this.lmxHandle[0], featureName, majorVer, minorVer, count, duration, token));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void reserveEarlyReturn(String featureName, String token) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCAdminReserveEarlyReturn(this.lmxHandle[0], featureName, token));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void uploadLicense(String licenseFilename, String licenseContent) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCAdminUploadLicense(this.lmxHandle[0], licenseFilename, licenseContent));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void restartServer(String hostname, int port, String password) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCAdminRestartServer(this.lmxHandle[0], hostname, port, password));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void shutdownServer(String hostname, int port, String password) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCAdminShutdownServer(this.lmxHandle[0], hostname, port, password));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    static {
        System.loadLibrary("lmxjava");
    }
}

