/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.coverage;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.emf.ecore.EObject;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="subjectID")
@JsonIgnoreProperties(value={"subject", "parent", "root"})
public class Measurement {
    private String name;
    private UUID measurementID;
    private long timestamp = 0L;
    private String subjectID;
    private EObject subject;
    private String label;
    private Class<?> type;
    private Measurement parent;
    private List<Measure> measures = new ArrayList<Measure>();
    private List<Measurement> children = new AbstractList<Measurement>(){
        private final List<Measurement> elements = new ArrayList<Measurement>();

        @Override
        public Measurement get(int index) {
            return this.elements.get(index);
        }

        @Override
        public Measurement set(int index, Measurement element) {
            Measurement previous = this.elements.set(index, element);
            previous.parent = null;
            element.parent = Measurement.this;
            return previous;
        }

        @Override
        public void add(int index, Measurement element) {
            this.elements.add(index, element);
            element.parent = Measurement.this;
        }

        @Override
        public Measurement remove(int index) {
            Measurement removed = this.elements.remove(index);
            if (removed != null) {
                removed.parent = null;
            }
            return removed;
        }

        @Override
        public int size() {
            return this.elements.size();
        }
    };

    public void addMeasure(Measure measure) {
        this.measures.add(measure);
    }

    protected void generateID() {
        if (this.subjectID == null && this.subject != null) {
            try {
                this.subjectID = this.subject.eResource().getURIFragment(this.subject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String id) {
        this.name = id;
    }

    public UUID getMeasurementID() {
        return this.measurementID;
    }

    public void setMeasurementID(UUID measurementID) {
        this.measurementID = measurementID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setSubjectID(String id) {
        this.subjectID = id;
    }

    public String getSubjectID() {
        return this.subjectID;
    }

    public EObject getSubject() {
        return this.subject;
    }

    public void setSubject(EObject subject) {
        this.subject = subject;
        this.generateID();
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public List<Measurement> getChildren() {
        return this.children;
    }

    public Measurement getParent() {
        return this.parent;
    }

    public void setParent(Measurement measurement) {
        this.parent = measurement;
    }

    public Measurement getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<Measure> getMeasures() {
        return this.measures;
    }

    public void setMeasures(List<Measure> measures) {
        this.measures = measures;
    }

    public static class Measure {
    }

    public static class StateTransitionCoverage
    extends Measure {
        public static final StateTransitionCoverage FULLY_COVERED = new StateTransitionCoverage(1.0f, 1);
        public static final StateTransitionCoverage NOT_COVERED = new StateTransitionCoverage(0.0f, 1);
        public static final StateTransitionCoverage ZERO = new StateTransitionCoverage(0.0f, 0);
        public float coverage;
        public int weight;

        public StateTransitionCoverage(float coverage, int weight) {
            this.coverage = coverage;
            this.weight = weight;
        }

        public StateTransitionCoverage operator_plus(StateTransitionCoverage p2) {
            int totalWeight = this.weight + p2.weight;
            return new StateTransitionCoverage(((float)this.weight * this.coverage + (float)p2.weight * p2.coverage) / (float)Math.max(1, totalWeight), totalWeight);
        }
    }

    public static class TestCaseCount
    extends Measure {
        public int testCases;

        public TestCaseCount(int count) {
            this.testCases = count;
        }
    }

    public static class Visits
    extends Measure {
        public int count;

        public void increase() {
            ++this.count;
        }
    }
}

