/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.coverage;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@Singleton
public class MeasurementContext {
    @Inject
    protected volatile Measurement root;
    protected volatile Measurement current;
    protected List<Consumer<Measurement>> listeners = new ArrayList<Consumer<Measurement>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Measurement getRootMeasurement() {
        if (this.root == null) {
            MeasurementContext measurementContext = this;
            synchronized (measurementContext) {
                if (this.root == null) {
                    this.root = new Measurement();
                    this.root.setTimestamp(System.currentTimeMillis());
                    this.current = this.root;
                }
            }
        }
        return this.root;
    }

    public Measurement getCurrentMeasurement() {
        return this.current;
    }

    public synchronized void setCurrentMeasurement(Measurement measurement) {
        if (measurement != null) {
            this.current = measurement;
        }
    }

    public void addListener(Consumer<Measurement> listener) {
        this.listeners.add(listener);
        listener.accept(this.current);
    }

    public void removeListener(Consumer<Measurement> listener) {
        this.listeners.remove(listener);
    }

    public void changed() {
        this.listeners.stream().forEach(l -> l.accept(this.root));
    }
}

