/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.launch;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.license.LicenseChecker;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.resource.ResourceUtil;
import com.yakindu.sct.simulation.core.debugmodel.SCTDebugTarget;
import com.yakindu.sct.simulation.core.engine.ISimulationEngine;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;

public abstract class AbstractSCTLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public String FILE_NAME = "filename";
    public String DEFAULT_FILE_NAME = "";
    protected static final IStatus licenseError = new Status(4, "com.yakindu.sct.simulation.core", 200, "No valid license found. Simulation cannot be started.\nPlease check your license preferences under 'itemis CREATE Licenses'.", null);
    @Inject
    private Provider<ILaunchConfigurationDelegate> delegateProvider;

    protected abstract ISimulationEngine createExecutionContainer(ILaunch var1, Statechart var2, Injector var3);

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String filename = configuration.getAttribute(this.FILE_NAME, this.DEFAULT_FILE_NAME);
        URI uri = URI.createPlatformResourceURI((String)filename, (boolean)true);
        if (!URIConverter.INSTANCE.exists(uri, Collections.emptyMap())) {
            return false;
        }
        if (!this.isLicenseValid()) {
            IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(licenseError);
            prompter.handleStatus(licenseError, (Object)configuration);
            return false;
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    public synchronized void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String filename = configuration.getAttribute(this.FILE_NAME, this.DEFAULT_FILE_NAME);
        Statechart statechart = this.loadStatechart(filename);
        Injector injector = this.getInjector(statechart, launch);
        try {
            SCTDebugTarget target = this.createDebugTarget(launch, statechart, injector);
            target.setPrimary(true);
            target.init();
            launch.addDebugTarget((IDebugTarget)target);
            ILaunchConfigurationDelegate delegate = (ILaunchConfigurationDelegate)this.delegateProvider.get();
            if (delegate != null) {
                delegate.launch(configuration, mode, launch, monitor);
            }
            target.start();
        }
        catch (InitializationException initializationException) {
            // empty catch block
        }
    }

    protected Injector getInjector(Statechart statechart, ILaunch launch) {
        return Guice.createInjector((Module[])new Module[]{this.getInjectionModule(statechart, launch)});
    }

    protected Module getInjectionModule(Statechart statechart, final ILaunch launch) {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(ILaunch.class).toInstance((Object)launch);
            }
        };
    }

    protected boolean isLicenseValid() {
        return new LicenseChecker().checkStandardLicense().isValidOrTrial();
    }

    protected SCTDebugTarget createDebugTarget(ILaunch launch, Statechart statechart, Injector injector) throws CoreException {
        Assert.isNotNull((Object)statechart);
        SCTDebugTarget target = new SCTDebugTarget(launch, (NamedElement)statechart, this.createExecutionContainer(launch, statechart, injector));
        injector.injectMembers((Object)target);
        return target;
    }

    protected Statechart loadStatechart(String filename) {
        return ResourceUtil.loadStatechart((String)filename);
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        String filename = configuration.getAttribute(this.FILE_NAME, "");
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(filename);
        return new IProject[]{resource.getProject()};
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public static class InitializationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InitializationException(String msg) {
            super(msg);
        }
    }
}

