/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.python.extensions;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.IntLiteral;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.generator.python.naming.Naming;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.InternalScope;
import com.yakindu.sct.model.stext.stext.OperationDefinition;
import com.yakindu.sct.model.stext.stext.StatechartScope;
import com.yakindu.sctunit.generator.base.extensions.BaseMockingExtensions;
import com.yakindu.sctunit.generator.python.extensions.CallbackExtensions;
import com.yakindu.sctunit.generator.python.extensions.NamingExtensions;
import com.yakindu.sctunit.generator.python.extensions.SCTUnitPythonExpressionExtensions;
import com.yakindu.sctunit.sCTUnit.MockReturnStatement;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@Singleton
public class UnittestMockingExtensions
extends BaseMockingExtensions {
    @Inject
    @Extension
    private NamingExtensions _namingExtensions;
    @Inject
    @Extension
    private SCTUnitPythonExpressionExtensions _sCTUnitPythonExpressionExtensions;
    @Inject
    @Extension
    private CallbackExtensions _callbackExtensions;
    @Inject
    @Extension
    private ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    private ITypeSystem _iTypeSystem;
    @Inject
    @Extension
    private Naming _naming;
    private List<Operation> mockedOperations;

    public void clearMockedOperations() {
        boolean _not;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.mockedOperations);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            this.mockedOperations.clear();
        }
    }

    public String mockingImports(SCTUnitClass it, GeneratorEntry entry) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("from unittest import mock");
        _builder.newLine();
        return _builder.toString();
    }

    public CharSequence defaultMock(Scope scope) {
        StringConcatenation _builder = new StringConcatenation();
        List _list = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)scope.getMembers(), OperationDefinition.class));
        for (OperationDefinition operation : _list) {
            _builder.append("#pylint: disable=unused-argument");
            _builder.newLine();
            _builder.append("def default_");
            CharSequence _mockOperationName = this._callbackExtensions.getMockOperationName((EObject)scope, operation);
            _builder.append((Object)_mockOperationName);
            _builder.append("(*args, **kwargs):");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _returnDefaultValue = this.returnDefaultValue(operation.getType());
            _builder.append(_returnDefaultValue, "\t");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String returnDefaultValue(Type it) {
        boolean _isSame = this._iTypeSystem.isSame(it, this._iTypeSystem.getType("boolean"));
        if (_isSame) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("return False");
            return _builder.toString();
        }
        boolean _isSame_1 = this._iTypeSystem.isSame(it, this._iTypeSystem.getType("integer"));
        if (_isSame_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("return 0");
            return _builder_1.toString();
        }
        boolean _isSame_2 = this._iTypeSystem.isSame(it, this._iTypeSystem.getType("real"));
        if (_isSame_2) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("return 0.0");
            return _builder_2.toString();
        }
        boolean _isSame_3 = this._iTypeSystem.isSame(it, this._iTypeSystem.getType("string"));
        if (_isSame_3) {
            return "return ''";
        }
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("pass");
        return _builder_3.toString();
    }

    protected String _mockOperationCallbacks(Scope it) {
        return null;
    }

    protected String _mockOperationCallbacks(InterfaceScope it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _setOperationCallback = this._callbackExtensions.setOperationCallback((StatechartScope)it);
        _builder.append((Object)_setOperationCallback);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected String _mockOperationCallbacks(InternalScope it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _setOperationCallback = this._callbackExtensions.setOperationCallback((StatechartScope)it);
        _builder.append((Object)_setOperationCallback);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected CharSequence argumentCaptureInit(Type type, String name, int index, VerifyCalledStatement ve) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ArgumentCaptor<");
        String _firstUpper = StringExtensions.toFirstUpper((String)this._iCodegenTypeSystemAccess.getTargetLanguageName(type));
        _builder.append(_firstUpper);
        _builder.append("> ");
        CharSequence _argumentCapture = this._namingExtensions.argumentCapture(type);
        _builder.append((Object)_argumentCapture);
        _builder.append(name);
        _builder.append("_");
        int _statementIndex = this.getStatementIndex((TestStatement)ve);
        _builder.append((Object)_statementIndex);
        _builder.append("_");
        _builder.append((Object)index);
        _builder.append(" = forClass(");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)this._iCodegenTypeSystemAccess.getTargetLanguageName(type));
        _builder.append(_firstUpper_1);
        _builder.append(".class);");
        return _builder;
    }

    public String generateVerify(VerifyCalledStatement it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("self.");
        boolean _isNegated = it.isNegated();
        if (_isNegated) {
            _builder.append("assertFalse");
        } else {
            _builder.append("assertTrue");
        }
        _builder.append("(");
        String _callCount = this.callCount(it);
        _builder.append(_callCount);
        _builder.append(" >=");
        IntLiteral _elvis = null;
        IntLiteral _times = it.getTimes();
        if (_times != null) {
            _elvis = _times;
        } else {
            PrimitiveValueExpression _intLiteral = this._sCTUnitPythonExpressionExtensions.intLiteral(1);
            _elvis = _intLiteral;
        }
        CharSequence _code = this._sCTUnitPythonExpressionExtensions.code((EObject)_elvis);
        _builder.append((Object)_code);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String callCount(VerifyCalledStatement it) {
        Scope scope = this._baseNavigationExtensions.getScope((EObject)this.getOperation(it.getReference()));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("self.");
        String _statemachineReferenceName = this._namingExtensions.statemachineReferenceName();
        _builder.append(_statemachineReferenceName);
        _builder.append(".");
        CharSequence _operationCallBack = this._namingExtensions.operationCallBack(scope);
        _builder.append((Object)_operationCallBack);
        _builder.append(".");
        String _operationName = this.getOperationName(it);
        _builder.append(_operationName);
        String operation = _builder.toString();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.getExpressions(it.getReference()));
        if (_isNullOrEmpty) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(operation);
            _builder_1.append(".call_count");
            return _builder_1.toString();
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("len([call for call in ");
        _builder_2.append(operation);
        _builder_2.append(".call_args_list if call == call(");
        EList<Expression> _expressions = this.getExpressions(it.getReference());
        boolean _hasElements = false;
        for (Expression arg : _expressions) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder_2.appendImmediate((Object)", ", "");
            }
            CharSequence _code = this._sCTUnitPythonExpressionExtensions.code((EObject)arg);
            _builder_2.append((Object)_code);
        }
        _builder_2.append(")])");
        return _builder_2.toString();
    }

    protected EList<Expression> _getExpressions(ArgumentExpression reference) {
        return reference.getExpressions();
    }

    protected EList<Expression> _getExpressions(Expression reference) {
        return null;
    }

    protected CharSequence getCaptureName(Parameter param, VerifyCalledStatement ve) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _argumentCapture = this._namingExtensions.argumentCapture(param.getType());
        _builder.append((Object)_argumentCapture);
        String _operationName = this.getOperationName(ve);
        _builder.append(_operationName);
        _builder.append("_");
        int _statementIndex = this.getStatementIndex((TestStatement)ve);
        _builder.append((Object)_statementIndex);
        _builder.append("_");
        int _indexOf = this.getOperation(ve.getReference()).getParameters().indexOf((Object)param);
        _builder.append((Object)_indexOf);
        return _builder;
    }

    protected String getOperationName(VerifyCalledStatement ve) {
        return this._naming.identifier((EObject)this.getOperation(ve.getReference()));
    }

    protected int getStatementIndex(TestStatement stmt) {
        Object _eGet = stmt.eContainer().eGet(stmt.eContainingFeature());
        return ((List)_eGet).indexOf(stmt);
    }

    public String generateMockReturn(MockReturnStatement stm) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isAlreadyMocked = this.isAlreadyMocked(stm);
        boolean bl = _not = !_isAlreadyMocked;
        if (_not) {
            _builder.append("self.");
            String _statemachineReferenceName = this._namingExtensions.statemachineReferenceName();
            _builder.append(_statemachineReferenceName);
            _builder.append(".");
            CharSequence _operationCallBack = this._namingExtensions.operationCallBack(this._baseNavigationExtensions.getScope((EObject)this.getOperation(stm.getReference())));
            _builder.append((Object)_operationCallBack);
            _builder.append(".");
            String _identifier = this._naming.identifier((EObject)this.getOperation(stm.getReference()));
            _builder.append(_identifier);
            _builder.append(" = mock.Mock(side_effect=");
            String _identifier_1 = this._naming.identifier((EObject)this.getOperation(stm.getReference()));
            _builder.append(_identifier_1);
            _builder.append("_side_effect)");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    protected boolean isAlreadyMocked(MockReturnStatement stm) {
        if (this.mockedOperations == null) {
            ArrayList<Operation> _arrayList = new ArrayList<Operation>();
            this.mockedOperations = _arrayList;
        }
        for (Operation op : this.mockedOperations) {
            int _hashCode_1;
            boolean _equals;
            int _hashCode = this.getOperation(stm.getReference()).hashCode();
            boolean bl = _equals = _hashCode == (_hashCode_1 = op.hashCode());
            if (!_equals) continue;
            return true;
        }
        this.mockedOperations.add(this.getOperation(stm.getReference()));
        return false;
    }

    public Map<Operation, LinkedList<MockReturnStatement>> generateSideEffectList(SCTUnitOperation it) {
        boolean _not;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.mockedOperations);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            this.mockedOperations.clear();
        }
        HashMap<Operation, LinkedList<MockReturnStatement>> map = new HashMap<Operation, LinkedList<MockReturnStatement>>();
        boolean found = false;
        EList _code = it.getBody().getCode();
        for (TestStatement s : _code) {
            if (!(s instanceof MockReturnStatement)) continue;
            boolean _isEmpty = map.isEmpty();
            if (_isEmpty) {
                this.addNewLinkedListToMap(map, (MockReturnStatement)s);
                continue;
            }
            Set<Operation> _keySet = map.keySet();
            for (Operation k : _keySet) {
                int _hashCode_1;
                boolean _equals;
                int _hashCode = k.hashCode();
                boolean bl2 = _equals = _hashCode == (_hashCode_1 = this.getOperation(((MockReturnStatement)s).getReference()).hashCode());
                if (!_equals) continue;
                found = true;
                if (s instanceof MockReturnStatement && this.getOperationParameters((MockReturnStatement)s).isEmpty()) {
                    map.get(k).addLast((MockReturnStatement)s);
                    continue;
                }
                map.get(k).addFirst((MockReturnStatement)s);
            }
            if (!found) {
                this.addNewLinkedListToMap(map, (MockReturnStatement)s);
                continue;
            }
            found = false;
        }
        return map;
    }

    private LinkedList<MockReturnStatement> addNewLinkedListToMap(HashMap<Operation, LinkedList<MockReturnStatement>> map, MockReturnStatement s) {
        LinkedList<MockReturnStatement> _xblockexpression = null;
        LinkedList<MockReturnStatement> l = new LinkedList<MockReturnStatement>();
        l.add(s);
        _xblockexpression = map.put(this.getOperation(s.getReference()), l);
        return _xblockexpression;
    }

    public CharSequence generateSideEffects(Map<Operation, LinkedList<MockReturnStatement>> map) {
        StringConcatenation _builder = new StringConcatenation();
        if (map != null || map.isEmpty()) {
            Set<Map.Entry<Operation, LinkedList<MockReturnStatement>>> _entrySet = map.entrySet();
            for (Map.Entry<Operation, LinkedList<MockReturnStatement>> entry : _entrySet) {
                boolean _not;
                _builder.append("#pylint: disable=unused-argument");
                _builder.newLine();
                _builder.append("def ");
                String _identifier = this._naming.identifier((EObject)entry.getKey());
                _builder.append(_identifier);
                _builder.append("_side_effect(*args, **kwargs):");
                _builder.newLineIfNotEmpty();
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)entry.getValue());
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    LinkedList<MockReturnStatement> _value = entry.getValue();
                    for (MockReturnStatement mrs : _value) {
                        boolean _not_1;
                        boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty(this.argumentExpressions(mrs.getReference()));
                        boolean bl2 = _not_1 = !_isNullOrEmpty_1;
                        if (!_not_1) continue;
                        _builder.append("\t");
                        _builder.append("if args[0] == (");
                        List<Parameter> _operationParameters = this.getOperationParameters(mrs);
                        for (Parameter p : _operationParameters) {
                            CharSequence _code = this._sCTUnitPythonExpressionExtensions.code((EObject)this.argumentExpressions(mrs.getReference()).get(this.getOperationParameters(mrs).indexOf(p)));
                            _builder.append((Object)_code, "\t");
                        }
                        _builder.append("):");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("return ");
                        CharSequence _code_1 = this._sCTUnitPythonExpressionExtensions.code((EObject)mrs.getValue());
                        _builder.append((Object)_code_1, "\t\t");
                        _builder.newLineIfNotEmpty();
                    }
                    LinkedList<MockReturnStatement> _value_1 = entry.getValue();
                    for (MockReturnStatement mrs_1 : _value_1) {
                        boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty(this.argumentExpressions(mrs_1.getReference()));
                        if (!_isNullOrEmpty_2) continue;
                        _builder.append("\t");
                        _builder.append("return ");
                        CharSequence _code_2 = this._sCTUnitPythonExpressionExtensions.code((EObject)mrs_1.getValue());
                        _builder.append((Object)_code_2, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                } else {
                    _builder.append("\t");
                    _builder.append("return ");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.newLine();
            }
        }
        return _builder;
    }

    protected List<Parameter> getOperationParameters(MockReturnStatement it) {
        return this.getOperation(it.getReference()).getParameters();
    }

    protected List<Expression> _argumentExpressions(Expression it) {
        return null;
    }

    protected List<Expression> _argumentExpressions(ElementReferenceExpression it) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)it.getExpressions());
        if (_isNullOrEmpty) {
            return Collections.emptyList();
        }
        return it.getExpressions();
    }

    protected List<Expression> _argumentExpressions(FeatureCall it) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)it.getExpressions());
        if (_isNullOrEmpty) {
            return Collections.emptyList();
        }
        return it.getExpressions();
    }

    @XbaseGenerated
    public String mockOperationCallbacks(Scope it) {
        if (it instanceof InterfaceScope) {
            return this._mockOperationCallbacks((InterfaceScope)it);
        }
        if (it instanceof InternalScope) {
            return this._mockOperationCallbacks((InternalScope)it);
        }
        if (it != null) {
            return this._mockOperationCallbacks(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public EList<Expression> getExpressions(Expression reference) {
        if (reference instanceof ArgumentExpression) {
            return this._getExpressions((ArgumentExpression)reference);
        }
        if (reference != null) {
            return this._getExpressions(reference);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(reference).toString());
    }

    @XbaseGenerated
    public List<Expression> argumentExpressions(Expression it) {
        if (it instanceof ElementReferenceExpression) {
            return this._argumentExpressions((ElementReferenceExpression)it);
        }
        if (it instanceof FeatureCall) {
            return this._argumentExpressions((FeatureCall)it);
        }
        if (it != null) {
            return this._argumentExpressions(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

