/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.python.features;

import com.yakindu.sct.generator.core.library.impl.CoreLibraryDefaultFeatureValueProvider;
import com.yakindu.sct.generator.python.features.IPythonFeatureConstants;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public class PythonFeatureValueProvider
extends CoreLibraryDefaultFeatureValueProvider {
    private static final String PACKAGE_NAME_REGEX = "([a-zA-Z_][a-zA-Z0-9_\\.]*)+[a-zA-Z_][a-zA-Z0-9_]*";

    public void setDefaultValue(FeatureType featureType, FeatureParameterValue parameterValue, EObject contextElement) {
        super.setDefaultValue(featureType, parameterValue, contextElement);
        String parameterName = parameterValue.getParameter().getName();
        if ("basePackage".equals(parameterName)) {
            parameterValue.setValue("");
        }
        if ("libraryPackage".equals(parameterName)) {
            parameterValue.setValue("yakindu");
        }
        if ("targetFolder".equals(parameterName)) {
            parameterValue.setValue("srcgen");
        }
    }

    public boolean isProviderFor(FeatureTypeLibrary library) {
        return library.getName().equals("Python Generator") || library.getName().equals("Core");
    }

    public IStatus validateParameterValue(FeatureParameterValue value) {
        IStatus superResult = super.validateParameterValue(value);
        if (superResult != Status.OK_STATUS) {
            return superResult;
        }
        String name = value.getParameter().getName();
        if ("basePackage".equals(name) || "libraryPackage".equals(name)) {
            if (value.getStringValue().isEmpty()) {
                return Status.OK_STATUS;
            }
            if (!value.getStringValue().matches(PACKAGE_NAME_REGEX)) {
                return this.error("Invalid package name");
            }
            for (String keyword : Arrays.asList(IPythonFeatureConstants.PYTHON_KEYWORDS)) {
                Pattern pattern = Pattern.compile("(?:^|\\.)" + keyword + "(?:$|\\.)");
                Matcher matcher = pattern.matcher(value.getStringValue());
                if (!matcher.find()) continue;
                return this.error("Python keyword '" + matcher.group() + "' is not allowed in package names.");
            }
        }
        return Status.OK_STATUS;
    }
}

