/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.python.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.python.GenmodelEntries;
import com.yakindu.sct.generator.python.naming.Naming;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

public class RuntimeTemplate {
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;

    public void generateRuntimeTemplate(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        String _basePackagePath = this._genmodelEntries.getBasePackagePath(entry);
        String _plus = _basePackagePath + "/";
        String _py = this._naming.py("default_runtime");
        String filename = _plus + _py;
        CharSequence content = this.content(entry, flow);
        fsa.generateFile(filename, content);
    }

    private CharSequence content(GeneratorEntry entry, ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"\"\"");
        _builder.newLine();
        String _licenseText = this._genmodelEntries.getLicenseText(entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("This is a default template of a runtime environment for a");
        _builder.newLine();
        _builder.append("generated statemachine. It needs custom code to act like");
        _builder.newLine();
        _builder.append("intended, e.g. include methods to raise events etc.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.newLine();
        CharSequence _createImports = this.createImports(entry, flow);
        _builder.append((Object)_createImports);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class ");
        String _statemachineName = this._naming.statemachineName(flow);
        _builder.append(_statemachineName);
        _builder.append("Runtime:");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __init__(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.sm = ");
        String _statemachineName_1 = this._naming.statemachineName(flow);
        _builder.append(_statemachineName_1, "\t\t");
        _builder.append("()");
        _builder.newLineIfNotEmpty();
        boolean _isTimed = this._sExecExtensions.isTimed(flow);
        if (_isTimed) {
            _builder.append("\t\t");
            _builder.append("self.ti = Timer()");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("# Enter custom init code here..");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Enter custom methods here..");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def setup(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\" Get statemachine ready and enter it.");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        boolean _isTimed_1 = this._sExecExtensions.isTimed(flow);
        if (_isTimed_1) {
            _builder.append("\t\t");
            _builder.append("self.sm.timer_service = self.ti");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("self.sm.init()");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.sm.enter()");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def run(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\" Include your interface actions here");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("while True:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("# enter what you like to do");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.sm.run_cycle()");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def shutdown(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\" Unset timer and exit statemachine.");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("print('State machine shuts down.')");
        _builder.newLine();
        boolean _isTimed_2 = this._sExecExtensions.isTimed(flow);
        if (_isTimed_2) {
            _builder.append("\t\t");
            _builder.append("self.sm.unset_timer()");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("self.sm.exit()");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("print('Bye!')");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("if __name__ == \"__main__\":");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sr = ");
        String _statemachineName_2 = this._naming.statemachineName(flow);
        _builder.append(_statemachineName_2, "\t");
        _builder.append("Runtime()");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("sr.setup()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sr.run()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sr.shutdown()");
        _builder.newLine();
        return _builder;
    }

    private CharSequence createImports(GeneratorEntry entry, ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import sys, os");
        _builder.newLine();
        _builder.append("sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))");
        _builder.newLine();
        _builder.append("from ");
        String _lowerCase = this._naming.statemachineName(flow).toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".");
        String _statemachineClassName = this._naming.statemachineClassName((Notifier)flow);
        _builder.append(_statemachineClassName);
        _builder.append(" import ");
        String _statemachineName = this._naming.statemachineName(flow);
        _builder.append(_statemachineName);
        _builder.newLineIfNotEmpty();
        boolean _isTimed = this._sExecExtensions.isTimed(flow);
        if (_isTimed) {
            _builder.append("from ");
            String _lowerCase_1 = this._naming.statemachineName(flow).toLowerCase();
            _builder.append(_lowerCase_1);
            _builder.append(".timer.");
            String _Timer = this._naming.Timer();
            _builder.append(_Timer);
            _builder.append(" import Timer");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }
}

