/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.commands;

import com.yakindu.base.base.DocumentedElement;
import com.yakindu.sct.model.sgraph.SpecificationElement;
import com.yakindu.sct.ui.editor.StatechartImages;
import com.yakindu.sct.ui.editor.commands.AbstractActionRun;
import com.yakindu.sct.ui.editor.commands.ToggleShowDocumentationCommand;
import com.yakindu.sct.ui.editor.utils.GMFNotationUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;

public class DocOrExprAction
extends AbstractActionRun {
    public DocOrExprAction(String text) {
        this.setImageDescriptor(StatechartImages.MENU.imageDescriptor());
        this.setText(text);
    }

    @Override
    protected void show(List<View> views) {
        String documentationContents = "";
        String specificationContents = "";
        CompositeCommand command = new CompositeCommand("toggle documentation");
        for (View view : views) {
            StringValueStyle style = GMFNotationUtil.getStringValueStyle(view, "featureToShow");
            if (style == null) {
                style = ToggleShowDocumentationCommand.createInitialStyle(view);
            }
            if (view.getElement() instanceof SpecificationElement) {
                specificationContents = ((SpecificationElement)view.getElement()).getSpecification();
            }
            if (view.getElement() instanceof DocumentedElement) {
                documentationContents = ((DocumentedElement)view.getElement()).getDocumentation();
            }
            String typeLiteral = StringUtils.isEmpty((String)documentationContents) ? "specification" : "documentation";
            command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)style, (EStructuralFeature)NotationPackage.Literals.STRING_VALUE_STYLE__STRING_VALUE, (Object)typeLiteral)));
        }
        ToggleShowDocumentationCommand.executeCommand((ICommand)command);
    }
}

