/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.definitionsection;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class StyledTextActionHandler {
    private CopyActionHandler styledTextCopyActionHandler = new CopyActionHandler();
    private CutActionHandler styledTextCutActionHandler = new CutActionHandler();
    private PasteActionHandler styledTextPasteActionHandler = new PasteActionHandler();
    private SelectAllActionHandler styledTextSelectAllActionHandler = new SelectAllActionHandler();
    private PrintActionHandler styledTextPrintActionHandler = new PrintActionHandler();
    private IPropertyChangeListener copyActionListener = new PropertyChangeListener((IAction)this.styledTextCopyActionHandler);
    private IPropertyChangeListener cutActionListener = new PropertyChangeListener((IAction)this.styledTextCutActionHandler);
    private IPropertyChangeListener pasteActionListener = new PropertyChangeListener((IAction)this.styledTextPasteActionHandler);
    private IPropertyChangeListener selectAllActionListener = new PropertyChangeListener((IAction)this.styledTextSelectAllActionHandler);
    private IPropertyChangeListener printActionListener = new PropertyChangeListener((IAction)this.styledTextPrintActionHandler);
    private IAction copyAction;
    private IAction cutAction;
    private IAction pasteAction;
    private IAction selectAllAction;
    private IAction printAction;
    private StyledText styledText;
    private Listener textControlListener = new TextControlListener();
    protected MouseAdapter mouseAdapter = new MouseAdapter(){

        public void mouseUp(MouseEvent e) {
            StyledTextActionHandler.this.updateActionsEnableState();
        }
    };
    protected KeyAdapter keyAdapter = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            StyledTextActionHandler.this.updateActionsEnableState();
        }
    };

    public StyledTextActionHandler(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.styledTextCopyActionHandler);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.styledTextCutActionHandler);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.styledTextPasteActionHandler);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.styledTextSelectAllActionHandler);
        actionBars.setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)this.styledTextPrintActionHandler);
    }

    public void adaptStyledText(StyledText textWidget) {
        if (textWidget == null) {
            return;
        }
        this.styledText = textWidget;
        textWidget.addListener(26, this.textControlListener);
        textWidget.addListener(27, this.textControlListener);
        textWidget.addKeyListener((KeyListener)this.keyAdapter);
        textWidget.addMouseListener((MouseListener)this.mouseAdapter);
    }

    public boolean isHooked() {
        return this.styledText != null && !this.styledText.isDisposed();
    }

    public void dispose() {
        this.setCopyAction(null);
        this.setCutAction(null);
        this.setPasteAction(null);
        this.setSelectAllAction(null);
        this.setPrintAction(null);
    }

    public void removeStyledText(StyledText textWidget) {
        if (textWidget == null) {
            return;
        }
        textWidget.removeListener(26, this.textControlListener);
        textWidget.removeListener(27, this.textControlListener);
        textWidget.removeMouseListener((MouseListener)this.mouseAdapter);
        textWidget.removeKeyListener((KeyListener)this.keyAdapter);
        this.styledText = null;
        this.updateActionsEnableState();
    }

    public void setCopyAction(IAction action) {
        if (this.copyAction == action) {
            return;
        }
        if (this.copyAction != null) {
            this.copyAction.removePropertyChangeListener(this.copyActionListener);
        }
        this.copyAction = action;
        if (this.copyAction != null) {
            this.copyAction.addPropertyChangeListener(this.copyActionListener);
        }
        this.styledTextCopyActionHandler.updateEnabledState();
    }

    public void setCutAction(IAction action) {
        if (this.cutAction == action) {
            return;
        }
        if (this.cutAction != null) {
            this.cutAction.removePropertyChangeListener(this.cutActionListener);
        }
        this.cutAction = action;
        if (this.cutAction != null) {
            this.cutAction.addPropertyChangeListener(this.cutActionListener);
        }
        this.styledTextCutActionHandler.updateEnabledState();
    }

    public void setPasteAction(IAction action) {
        if (this.pasteAction == action) {
            return;
        }
        if (this.pasteAction != null) {
            this.pasteAction.removePropertyChangeListener(this.pasteActionListener);
        }
        this.pasteAction = action;
        if (this.pasteAction != null) {
            this.pasteAction.addPropertyChangeListener(this.pasteActionListener);
        }
        this.styledTextPasteActionHandler.updateEnabledState();
    }

    public void setSelectAllAction(IAction action) {
        if (this.selectAllAction == action) {
            return;
        }
        if (this.selectAllAction != null) {
            this.selectAllAction.removePropertyChangeListener(this.selectAllActionListener);
        }
        this.selectAllAction = action;
        if (this.selectAllAction != null) {
            this.selectAllAction.addPropertyChangeListener(this.selectAllActionListener);
        }
        this.styledTextSelectAllActionHandler.updateEnabledState();
    }

    public void setPrintAction(IAction action) {
        if (this.printAction == action) {
            return;
        }
        if (this.printAction != null) {
            this.printAction.removePropertyChangeListener(this.printActionListener);
        }
        this.printAction = action;
        if (this.printAction != null) {
            this.printAction.addPropertyChangeListener(this.printActionListener);
        }
        this.styledTextPrintActionHandler.updateEnabledState();
    }

    private void updateActionsEnableState() {
        this.styledTextCopyActionHandler.updateEnabledState();
        this.styledTextCutActionHandler.updateEnabledState();
        this.styledTextPasteActionHandler.updateEnabledState();
        this.styledTextSelectAllActionHandler.updateEnabledState();
        this.styledTextPrintActionHandler.updateEnabledState();
    }

    protected class CopyActionHandler
    extends Action {
        protected CopyActionHandler() {
            super("Copy");
            this.setId("StyledTextCopyActionHandler");
            this.setEnabled(false);
        }

        public void runWithEvent(Event event) {
            if (StyledTextActionHandler.this.styledText != null && !StyledTextActionHandler.this.styledText.isDisposed()) {
                StyledTextActionHandler.this.styledText.copy();
                return;
            }
            if (StyledTextActionHandler.this.copyAction != null) {
                StyledTextActionHandler.this.copyAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (StyledTextActionHandler.this.styledText != null && !StyledTextActionHandler.this.styledText.isDisposed()) {
                this.setEnabled(!StyledTextActionHandler.this.styledText.getSelectionText().isEmpty());
                return;
            }
            if (StyledTextActionHandler.this.copyAction != null) {
                this.setEnabled(StyledTextActionHandler.this.copyAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    protected class CutActionHandler
    extends Action {
        protected CutActionHandler() {
            super("Cut");
            this.setId("StyledTextCutActionHandler");
            this.setEnabled(false);
        }

        public void runWithEvent(Event event) {
            if (StyledTextActionHandler.this.styledText != null && !StyledTextActionHandler.this.styledText.isDisposed()) {
                StyledTextActionHandler.this.styledText.cut();
                return;
            }
            if (StyledTextActionHandler.this.cutAction != null) {
                StyledTextActionHandler.this.cutAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (StyledTextActionHandler.this.styledText != null && !StyledTextActionHandler.this.styledText.isDisposed()) {
                this.setEnabled(!StyledTextActionHandler.this.styledText.getSelectionText().isEmpty());
                return;
            }
            if (StyledTextActionHandler.this.cutAction != null) {
                this.setEnabled(StyledTextActionHandler.this.cutAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    protected class PasteActionHandler
    extends Action {
        protected PasteActionHandler() {
            super("Paste");
            this.setId("StyledTextPasteActionHandler");
            this.setEnabled(false);
        }

        public void runWithEvent(Event event) {
            if (StyledTextActionHandler.this.styledText != null && !StyledTextActionHandler.this.styledText.isDisposed()) {
                StyledTextActionHandler.this.styledText.paste();
                return;
            }
            if (StyledTextActionHandler.this.pasteAction != null) {
                StyledTextActionHandler.this.pasteAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (StyledTextActionHandler.this.styledText != null && !StyledTextActionHandler.this.styledText.isDisposed()) {
                this.setEnabled(true);
                return;
            }
            if (StyledTextActionHandler.this.pasteAction != null) {
                this.setEnabled(StyledTextActionHandler.this.pasteAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    protected class PrintActionHandler
    extends Action {
        protected PrintActionHandler() {
            super("Print");
            this.setId("StyledTextPrintActionHandler");
            this.setEnabled(false);
        }

        public void runWithEvent(Event event) {
            if (StyledTextActionHandler.this.styledText != null && !StyledTextActionHandler.this.styledText.isDisposed()) {
                StyledTextActionHandler.this.styledText.print();
                return;
            }
            if (StyledTextActionHandler.this.printAction != null) {
                StyledTextActionHandler.this.printAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (StyledTextActionHandler.this.styledText != null && !StyledTextActionHandler.this.styledText.isDisposed()) {
                this.setEnabled(!StyledTextActionHandler.this.styledText.getText().isEmpty());
                return;
            }
            if (StyledTextActionHandler.this.printAction != null) {
                this.setEnabled(StyledTextActionHandler.this.printAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    protected class PropertyChangeListener
    implements IPropertyChangeListener {
        private IAction actionHandler;

        protected PropertyChangeListener(IAction actionHandler) {
            this.actionHandler = actionHandler;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (StyledTextActionHandler.this.styledText != null) {
                return;
            }
            if (event.getProperty().equals("enabled")) {
                Boolean bool = (Boolean)event.getNewValue();
                this.actionHandler.setEnabled(bool.booleanValue());
            }
        }
    }

    protected class SelectAllActionHandler
    extends Action {
        protected SelectAllActionHandler() {
            super("Select All");
            this.setId("StyledTextSelectAllActionHandler");
            this.setEnabled(false);
        }

        public void runWithEvent(Event event) {
            if (StyledTextActionHandler.this.styledText != null && !StyledTextActionHandler.this.styledText.isDisposed()) {
                StyledTextActionHandler.this.styledText.selectAll();
                return;
            }
            if (StyledTextActionHandler.this.selectAllAction != null) {
                StyledTextActionHandler.this.selectAllAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (StyledTextActionHandler.this.styledText != null && !StyledTextActionHandler.this.styledText.isDisposed()) {
                this.setEnabled(!StyledTextActionHandler.this.styledText.getText().isEmpty());
                return;
            }
            if (StyledTextActionHandler.this.selectAllAction != null) {
                this.setEnabled(StyledTextActionHandler.this.selectAllAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    protected class TextControlListener
    implements Listener {
        protected TextControlListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    StyledTextActionHandler.this.styledText = (StyledText)event.widget;
                    StyledTextActionHandler.this.updateActionsEnableState();
                    break;
                }
                case 27: {
                    StyledTextActionHandler.this.styledText = null;
                    StyledTextActionHandler.this.updateActionsEnableState();
                    break;
                }
            }
        }
    }
}

