/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.definitionsection;

import com.yakindu.base.xtext.utils.jface.viewers.StyledTextXtextAdapter;
import com.yakindu.sct.ui.editor.definitionsection.ContextScopeHandler;
import com.yakindu.sct.ui.editor.definitionsection.StyledTextActionHandler;
import com.yakindu.sct.ui.editor.editor.StatechartDiagramActionbarContributor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;

public class StyledTextSelectionListener
extends StyledTextXtextAdapter.ChangeSelectionProviderOnFocusGain {
    private IAction copyAction;
    private IAction cutAction;
    private IAction pasteAction;
    private IAction selectAllAction;
    private IAction printAction;
    private StyledTextActionHandler actionHandler;
    private IContextActivation embeddedEditorCtx;

    public StyledTextSelectionListener(IWorkbenchPartSite site, StyledText widget, ISelectionProvider selectionProviderOnFocusGain) {
        super(site, selectionProviderOnFocusGain, widget);
        site.setSelectionProvider(selectionProviderOnFocusGain);
        widget.addFocusListener((FocusListener)this);
        widget.addDisposeListener((DisposeListener)this);
    }

    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        this.unhookActions(e);
        this.redefineParentContext("org.eclipse.xtext.ui.embeddedTextEditorScope", "org.eclipse.ui.contexts.dialogAndWindow");
    }

    public void focusGained(FocusEvent e) {
        this.releaseSelection();
        this.hookActions(e);
        this.redefineParentContext("org.eclipse.xtext.ui.embeddedTextEditorScope", "org.eclipse.ui.textEditorScope");
        super.focusGained(e);
    }

    protected void redefineParentContext(String childCtx, String parentCtx) {
        if (this.embeddedEditorCtx != null) {
            ContextScopeHandler.deactivateContext(this.embeddedEditorCtx);
            this.embeddedEditorCtx = null;
        } else {
            ContextScopeHandler.defineContext(childCtx, parentCtx);
            this.embeddedEditorCtx = ContextScopeHandler.activateContext(childCtx);
        }
    }

    protected void releaseSelection() {
        if (this.site != null && this.selectionProviderOnFocusGain != null && !this.site.getSelectionProvider().equals(this.selectionProviderOnFocusGain)) {
            this.site.getSelectionProvider().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    protected void hookActions(FocusEvent e) {
        if (this.actionHandler == null) {
            IActionBars bars = this.saveDiagramActions();
            this.actionHandler = new StyledTextActionHandler(bars);
        }
        if (!this.actionHandler.isHooked()) {
            this.actionHandler.adaptStyledText((StyledText)e.widget);
            this.restoreDiagramActions();
        }
    }

    protected void restoreDiagramActions() {
        this.actionHandler.setCopyAction(this.copyAction);
        this.actionHandler.setCutAction(this.cutAction);
        this.actionHandler.setPasteAction(this.pasteAction);
        this.actionHandler.setSelectAllAction(this.selectAllAction);
        this.actionHandler.setPrintAction(this.printAction);
    }

    protected IActionBars saveDiagramActions() {
        StatechartDiagramActionbarContributor contributor = (StatechartDiagramActionbarContributor)((IEditorSite)this.site).getActionBarContributor();
        this.copyAction = contributor.getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId());
        this.cutAction = contributor.getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId());
        this.pasteAction = contributor.getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.selectAllAction = contributor.getActionBars().getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.printAction = contributor.getActionBars().getGlobalActionHandler(ActionFactory.PRINT.getId());
        return contributor.getActionBars();
    }

    protected void unhookActions(FocusEvent e) {
        if (this.actionHandler != null && this.actionHandler.isHooked()) {
            this.actionHandler.removeStyledText((StyledText)e.widget);
        }
    }
}

