/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.editor;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;

public class DisableButtonsByPerspectiveListener
implements IPerspectiveListener {
    public static final String TESTING_PERSPECTIVE = "com.yakindu.sct.ui.TestingPerspective";
    private static final List<String> BUTTON_IDS = Lists.newArrayList((Object[])new String[]{"fontNameContributionItem", "fontSizeContributionItem", "zoomContributionItem", "fillColorContributionItem", "lineColorContributionItem", "fontColorContributionItem", "fontBoldAction", "fontItalicAction", "autoSizeAction", "routerMenu", "selectMenu", "compartmentMenu", "alignMenu", "hideConnectorLabels", "showConnectorLabels", "copyAppearancePropertiesAction", "com.yakindu.sct.ui.editor.commands.toggleDocumentation"});
    private IActionBars bars;

    public DisableButtonsByPerspectiveListener(IActionBars bars) {
        this.bars = bars;
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.setToolbarButtons(this.bars, perspective);
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        this.setToolbarButtons(this.bars, perspective);
    }

    void setToolbarButtons(IActionBars bars, IPerspectiveDescriptor perspective) {
        this.enableEditingButtons(bars.getToolBarManager(), !this.relevantPerspective(perspective));
    }

    public boolean relevantPerspective(IPerspectiveDescriptor perspective) {
        return "com.yakindu.sct.ui.SimulationPerspective".equals(perspective.getId()) || TESTING_PERSPECTIVE.equals(perspective.getId());
    }

    private void enableEditingButtons(IToolBarManager tb, boolean isVisible) {
        for (String id : BUTTON_IDS) {
            IContributionItem item = tb.find(id);
            if (item == null) continue;
            item.setVisible(isVisible);
        }
        tb.update(true);
    }
}

