/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.editparts;

import com.yakindu.base.gmf.runtime.editparts.LiveFeedbackNonResizableEditPolicy;
import com.yakindu.base.gmf.runtime.editpolicies.OneWayConnectionHandlesEditPolicy;
import com.yakindu.base.gmf.runtime.figures.EllipseAnchorDefaultSizeNodeFigure;
import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.ui.editor.editor.figures.DeepHistoryFigure;
import com.yakindu.sct.ui.editor.editor.figures.InitialStateFigure;
import com.yakindu.sct.ui.editor.editor.figures.ShallowHistoryFigure;
import com.yakindu.sct.ui.editor.editor.figures.utils.MapModeUtils;
import com.yakindu.sct.ui.editor.editparts.BorderedShapeEditPart;
import com.yakindu.sct.ui.editor.policies.ContextSensitiveHelpPolicy;
import com.yakindu.sct.ui.editor.policies.EnlargeContainerEditPolicy;
import com.yakindu.sct.ui.editor.policies.FixedBendpointEditPolicy;
import com.yakindu.sct.ui.editor.utils.GMFNotationUtil;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class EntryEditPart
extends BorderedShapeEditPart {
    public EntryEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new OneWayConnectionHandlesEditPolicy(ConnectionHandle.HandleDirection.OUTGOING));
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new LiveFeedbackNonResizableEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ContextSensitiveHelpPolicy("com.yakindu.sct.ui.editor.sc_properties_entry_entrykind"));
        this.installEditPolicy(EnlargeContainerEditPolicy.ROLE, (EditPolicy)new EnlargeContainerEditPolicy());
        this.installEditPolicy("Fixed_Bendpoints", (EditPolicy)new FixedBendpointEditPolicy());
    }

    public Entry resolveSemanticElement() {
        return (Entry)super.resolveSemanticElement();
    }

    protected Ellipse createPrimaryShape() {
        switch (this.resolveSemanticElement().getKind()) {
            case DEEP_HISTORY: {
                return new DeepHistoryFigure();
            }
            case SHALLOW_HISTORY: {
                return new ShallowHistoryFigure();
            }
            case INITIAL: {
                return new InitialStateFigure();
            }
        }
        throw new IllegalStateException();
    }

    protected void handleNotificationEvent(Notification notification) {
        if (SGraphPackage.eINSTANCE.getEntry_Kind().equals(notification.getFeature())) {
            this.getMainFigure().add((IFigure)this.createPrimaryShape());
        }
        super.handleNotificationEvent(notification);
    }

    public Node getNotationView() {
        return (Node)super.getNotationView();
    }

    @Override
    protected NodeFigure createMainFigure() {
        EllipseAnchorDefaultSizeNodeFigure figure = new EllipseAnchorDefaultSizeNodeFigure(MapModeUtils.DEFAULT_SMALL_NODE_DIMENSION);
        figure.setLayoutManager((LayoutManager)new StackLayout());
        figure.add((IFigure)this.createPrimaryShape());
        figure.setBackgroundColor(ColorConstants.black);
        figure.setForegroundColor(ColorConstants.white);
        return figure;
    }

    protected void setBackgroundColor(Color c) {
        if (GMFNotationUtil.getNamedStyle((View)this.getNotationView(), NamedStyle.class, "allowColors") != null) {
            this.getMainFigure().setBackgroundColor(c);
        }
        super.setBackgroundColor(c);
    }

    protected void setForegroundColor(Color color) {
        if (GMFNotationUtil.getNamedStyle((View)this.getNotationView(), NamedStyle.class, "allowColors") != null) {
            this.getMainFigure().setForegroundColor(color);
        }
        super.setForegroundColor(color);
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
            return FigureUtilities.RGBToInteger((RGB)ColorConstants.white.getRGB());
        }
        if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            return FigureUtilities.RGBToInteger((RGB)ColorConstants.black.getRGB());
        }
        return super.getPreferredValue(feature);
    }
}

