/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.policies;

import com.google.common.collect.Lists;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.ui.editor.utils.SemanticHintUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class RegionCompartmentCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    protected List getSemanticChildrenList() {
        return this.getSemanticHost().getVertices();
    }

    protected List getSemanticConnectionsList() {
        ArrayList transitions = Lists.newArrayList();
        EList vertices = this.getSemanticHost().getVertices();
        for (Vertex vertex : vertices) {
            transitions.addAll(vertex.getOutgoingTransitions());
        }
        return transitions;
    }

    protected boolean shouldIncludeConnection(Edge connection, Collection<View> children) {
        EObject element = connection.getElement();
        if (element instanceof Transition) {
            Vertex source = ((Transition)element).getSource();
            if (!this.getSemanticHost().getVertices().contains((Object)source)) {
                return false;
            }
        }
        return super.shouldIncludeConnection(connection, children);
    }

    protected EObject getSourceElement(EObject relationship) {
        Assert.isTrue((boolean)(relationship instanceof Transition));
        Transition transition = (Transition)relationship;
        return transition.getSource();
    }

    protected EObject getTargetElement(EObject relationship) {
        Assert.isTrue((boolean)(relationship instanceof Transition));
        Transition transition = (Transition)relationship;
        return transition.getTarget();
    }

    public Region getSemanticHost() {
        return (Region)super.getSemanticHost();
    }

    public IGraphicalEditPart getHost() {
        return (IGraphicalEditPart)super.getHost();
    }

    protected String getFactoryHint(IAdaptable elementAdapter) {
        EObject modelElement = (EObject)elementAdapter.getAdapter(EObject.class);
        String factoryHint = SemanticHintUtil.getSemanticHint(modelElement);
        return factoryHint;
    }

    protected boolean shouldDeleteView(View view) {
        return !ViewType.NOTE.equals(view.getType()) && !ViewType.NOTEATTACHMENT.equals(view.getType()) && !ViewType.TEXT.equals(view.getType());
    }

    protected String getDefaultFactoryHint() {
        return "Transition";
    }

    protected void refreshSemantic() {
        List createdViews = super.refreshSemanticChildren();
        List createdConnectionViews = this.refreshSemanticConnections();
        ArrayList allViews = new ArrayList(createdConnectionViews.size() + createdViews.size());
        allViews.addAll(createdViews);
        allViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(allViews);
        this.persistTransientViews(createdViews);
    }

    protected void persistTransientViews(List<IAdaptable> createdViews) {
        this.getHost().getNotationView().getDiagram().persist();
    }
}

