/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.propertysheets;

import com.google.inject.Injector;
import com.yakindu.base.base.DomainElement;
import com.yakindu.base.xtext.utils.jface.fieldassist.CompletionProposalAdapter;
import com.yakindu.base.xtext.utils.jface.viewers.FilteringMenuManager;
import com.yakindu.base.xtext.utils.jface.viewers.StyledTextXtextAdapter;
import com.yakindu.base.xtext.utils.jface.viewers.util.ActiveEditorTracker;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.DomainStatus;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.model.sgraph.util.ContextElementAdapter;
import com.yakindu.sct.ui.editor.propertysheets.ValidatingEMFDatabindingContext;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractModelerPropertySection;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.xtext.EcoreUtil2;
import org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor;

public abstract class AbstractEditorPropertySection
extends AbstractModelerPropertySection {
    private FormToolkit toolkit;
    private EMFDataBindingContext bindingContext;
    private Form form;
    private CompletionProposalAdapter completionProposalAdapter;
    public static final String CONTEXTMENUID = "com.yakindu.base.xtext.utils.jface.viewers.StyledTextXtextAdapterContextMenu";

    public abstract void createControls(Composite var1);

    public abstract void bindModel(EMFDataBindingContext var1);

    public void refresh() {
        super.refresh();
    }

    public void dispose() {
        super.dispose();
        if (this.bindingContext != null) {
            this.bindingContext.dispose();
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    protected void setEObject(EObject newValue) {
        EObject oldValue = this.getEObject();
        super.setEObject(newValue);
        if (newValue != null && newValue != oldValue) {
            this.inputChanged();
        }
    }

    protected void inputChanged() {
        if (this.bindingContext != null) {
            this.bindingContext.dispose();
        }
        this.bindingContext = new ValidatingEMFDatabindingContext(this.getEObject(), this.form.getShell());
        this.bindModel(this.bindingContext);
    }

    public final void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.setBorderStyle(2048);
        super.createControls(parent, aTabbedPropertySheetPage);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.form = this.toolkit.createForm(parent);
        this.toolkit.decorateFormHeading(this.form);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.form);
        this.form.getBody().setLayout(this.createBodyLayout());
        this.createControls(this.form.getBody());
    }

    protected Layout createBodyLayout() {
        return new GridLayout(1, false);
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    protected void enableXtext(Control styledText, Injector injector) {
        StyledTextXtextAdapter xtextAdapter = new StyledTextXtextAdapter(injector);
        xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().add((Object)new ContextElementAdapter(this.getEObject()));
        xtextAdapter.adapt((StyledText)styledText, false);
        this.initContextMenu(styledText);
        this.completionProposalAdapter = new CompletionProposalAdapter(styledText, xtextAdapter.getContentAssistant(), KeyStroke.getInstance((int)262144, (int)32), null);
        this.form.getBody().setEnabled(this.isEditable());
    }

    protected void initContextMenu(Control control) {
        FilteringMenuManager menuManager = new FilteringMenuManager();
        Menu contextMenu = menuManager.createContextMenu(control);
        control.setMenu(contextMenu);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPartSite site = window.getActivePage().getActiveEditor().getSite();
        site.registerContextMenu(CONTEXTMENUID, (MenuManager)menuManager, site.getSelectionProvider());
    }

    public CompletionProposalAdapter getCompletionProposalAdapter() {
        return this.completionProposalAdapter;
    }

    protected Injector getInjector(String semanticTarget) {
        IEditorPart editor = ActiveEditorTracker.getLastActiveEditor();
        if (editor instanceof StatechartDiagramEditor) {
            IDomain domain = DomainRegistry.getDomain((EObject)((StatechartDiagramEditor)editor).getDiagram().getElement());
            return domain.getInjector("com.yakindu.sct.editor", new String[]{semanticTarget});
        }
        throw new IllegalArgumentException("Unknown editor " + String.valueOf(editor));
    }

    public EObject getContextObject() {
        return this.getEObject();
    }

    protected void createHelpWidget(Composite parent, final Control control, String helpId) {
        ImageHyperlink helpWidget = this.toolkit.createImageHyperlink(parent, 0x1000000);
        Image defaultImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        helpWidget.setImage(defaultImage);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)helpWidget);
        helpWidget.setToolTipText(JFaceResources.getString((String)"help"));
        helpWidget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                control.setFocus();
                PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)helpWidget);
        helpWidget.setEnabled(true);
        this.setHelpContext(control, helpId);
    }

    protected void setHelpContext(Control control, String helpId) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp(control, helpId);
    }

    public boolean isEditable() {
        DomainStatus domainStatus = this.getDomainStatus();
        return domainStatus != null && domainStatus.getSeverity() != DomainStatus.Severity.ERROR;
    }

    protected DomainStatus getDomainStatus() {
        EObject element = this.getEObject();
        DomainElement domainElement = (DomainElement)EcoreUtil2.getContainerOfType((EObject)element, DomainElement.class);
        if (domainElement != null) {
            DomainStatus domainStatus = DomainRegistry.getDomainStatus((String)domainElement.getDomainID());
            return domainStatus;
        }
        return null;
    }
}

