/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.propertysheets;

import com.google.inject.Injector;
import com.yakindu.base.base.BasePackage;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.ui.editor.propertysheets.AbstractTwoColumnEditorPropertySection;
import com.yakindu.sct.ui.editor.propertysheets.OrderElementControl;
import java.util.List;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StatechartPropertySection
extends AbstractTwoColumnEditorPropertySection
implements OrderElementControl.ISourceObjectCallback {
    private Control textControl;
    private Text txtName;
    protected OrderElementControl orderElementControl;
    private ComboViewer domainCombo;

    @Override
    protected Layout createLeftColumnLayout() {
        return new GridLayout(2, false);
    }

    @Override
    protected void createLeftColumnControls(Composite leftColumn) {
        this.createNameControl(leftColumn);
        this.createDomainCombo(leftColumn);
        this.createSpecificationControl(leftColumn);
    }

    protected void createDomainCombo(Composite leftColumn) {
        Label label = this.getToolkit().createLabel(leftColumn, "Statechart domain");
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).applyTo((Control)label);
        this.domainCombo = new ComboViewer(leftColumn);
        GridDataFactory.fillDefaults().span(1, 1).align(4, 0x1000000).applyTo((Control)this.domainCombo.getCombo());
        Label spacer = this.getToolkit().createLabel(leftColumn, "");
        GridDataFactory.fillDefaults().applyTo((Control)spacer);
        this.domainCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.domainCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IDomain)element).getName();
            }
        });
        List domains = DomainRegistry.getDomains();
        for (IDomain domainDescriptor : domains) {
            this.domainCombo.add((Object)domainDescriptor);
        }
        if (domains.size() <= 1) {
            this.domainCombo.getControl().setEnabled(false);
        }
    }

    @Override
    protected void createRightColumnControls(Composite rightColumn) {
        this.createDocumentationControl(rightColumn);
        this.createRegionsControl(rightColumn);
    }

    protected void createNameControl(Composite parent) {
        Label lblName = this.getToolkit().createLabel(parent, "Statechart Name: ");
        this.txtName = this.getToolkit().createText(parent, "");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)lblName);
        new Label(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.txtName);
    }

    protected void createRegionsControl(Composite rightColumn) {
        Label label = this.getToolkit().createLabel(rightColumn, "Region Priority:");
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.orderElementControl = new OrderElementControl(rightColumn, (EStructuralFeature)SGraphPackage.Literals.COMPOSITE_ELEMENT__REGIONS, this, "Statechart contains no regions");
        GridDataFactory.fillDefaults().span(2, 0).grab(true, false).applyTo((Control)this.orderElementControl);
    }

    protected void createSpecificationControl(Composite parent) {
        Label lblDocumentation = this.getToolkit().createLabel(parent, "Statechart Behavior: ");
        Injector injector = this.getInjector(Statechart.class.getName());
        if (injector != null) {
            this.textControl = new StyledText(parent, 2626);
            ((StyledText)this.textControl).setAlwaysShowScrollBars(false);
            this.createHelpWidget(parent, this.textControl, "com.yakindu.sct.ui.editor.sc_properties_statechart_expression");
        } else {
            this.textControl = this.getToolkit().createText(parent, "", 2);
        }
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)lblDocumentation);
        GridDataFactory.fillDefaults().grab(true, true).hint(parent.getSize()).applyTo(this.textControl);
    }

    @Override
    protected void inputChanged() {
        Injector injector = this.getInjector(Statechart.class.getName());
        if (injector != null) {
            this.enableXtext(this.textControl, injector);
        }
        super.inputChanged();
    }

    @Override
    public void bindModel(EMFDataBindingContext context) {
        this.bindNameControl(context);
        this.bindDomainCombo(context);
        this.bindSpecificationControl(context);
        this.bindDocumentationControl(context);
        this.orderElementControl.refreshInput();
    }

    protected void bindDomainCombo(EMFDataBindingContext context) {
        IEMFEditValueProperty property = EMFEditProperties.value((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.eObject), (EStructuralFeature)BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID);
        IViewerObservableValue observeSingleSelection = ViewerProperties.singleSelection().observe((Viewer)this.domainCombo);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy(){

            public Object convert(Object value) {
                return ((IDomain)value).getDomainID();
            }
        };
        UpdateValueStrategy targetToModel = new UpdateValueStrategy(){

            public Object convert(Object value) {
                return DomainRegistry.getDomain((String)((String)value));
            }
        };
        context.bindValue((IObservableValue)observeSingleSelection, property.observe((Object)this.eObject), modelToTarget, targetToModel);
    }

    protected void bindDocumentationControl(EMFDataBindingContext context) {
        IEMFEditValueProperty property = EMFEditProperties.value((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.eObject), (EStructuralFeature)BasePackage.Literals.DOCUMENTED_ELEMENT__DOCUMENTATION);
        ISWTObservableValue observe = WidgetProperties.text((int[])new int[]{16, 14}).observe((Widget)this.documentation);
        context.bindValue((IObservableValue)observe, property.observe((Object)this.eObject));
    }

    protected void bindSpecificationControl(EMFDataBindingContext context) {
        IEMFEditValueProperty modelProperty = EMFEditProperties.value((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.eObject), (EStructuralFeature)SGraphPackage.Literals.SPECIFICATION_ELEMENT__SPECIFICATION);
        ISWTObservableValue uiProperty = WidgetProperties.text((int)16).observe((Widget)this.textControl);
        context.bindValue((IObservableValue)uiProperty, modelProperty.observe((Object)this.eObject), null, new UpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                if (StatechartPropertySection.this.getCompletionProposalAdapter() != null && !StatechartPropertySection.this.getCompletionProposalAdapter().isProposalPopupOpen()) {
                    return super.doSet(observableValue, value);
                }
                return Status.OK_STATUS;
            }
        });
    }

    protected void bindNameControl(EMFDataBindingContext context) {
        IEMFEditValueProperty property = EMFEditProperties.value((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.eObject), (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
        ISWTObservableValue observe = WidgetProperties.text((int[])new int[]{16, 14}).observe((Widget)this.txtName);
        context.bindValue((IObservableValue)observe, property.observe((Object)this.eObject));
    }

    @Override
    public EObject getEObject() {
        return super.getEObject();
    }

    @Override
    public void dispose() {
        if (this.orderElementControl != null) {
            this.orderElementControl.dispose();
        }
        super.dispose();
    }
}

