/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.validation;

import com.google.inject.Inject;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.ui.editor.DiagramActivator;
import com.yakindu.sct.ui.editor.validation.ValidationJob;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;

public class LiveValidationListener
extends ResourceSetListenerImpl {
    private static final int DELAY = 200;
    @Inject
    private ValidationJob validationJob;
    private Resource resource;

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        for (Notification notification : event.getNotifications()) {
            if (notification.getNotifier() instanceof EObject && notification.getEventType() != 8 && notification.getEventType() != 9) {
                EObject eObject = (EObject)notification.getNotifier();
                if (eObject.eClass().getEPackage() == SGraphPackage.eINSTANCE) {
                    this.rescheduleJob();
                    break;
                }
                for (EClass eClass : eObject.eClass().getEAllSuperTypes()) {
                    if (SGraphPackage.eINSTANCE != eClass.getEPackage()) continue;
                    this.rescheduleJob();
                    return;
                }
                continue;
            }
            if (!(notification.getNotifier() instanceof Resource) || this.resource == null || this.resource.equals(notification.getNotifier())) continue;
            this.rescheduleJob();
        }
    }

    protected void rescheduleJob() {
        this.validationJob.cancel();
        if (this.liveValidationEnabled()) {
            this.validationJob.schedule(200L);
        }
    }

    public void scheduleValidation() {
        if (this.liveValidationEnabled()) {
            this.validationJob.schedule(200L);
        }
    }

    protected boolean liveValidationEnabled() {
        return DiagramActivator.getDefault().getPreferenceStore().getBoolean("Appearance.live.validation");
    }

    public void setResource(Resource resource) {
        this.resource = resource;
        this.validationJob.setResource(resource);
    }

    public void setValidationIssueProcessor(IValidationIssueProcessor validationIssueProcessor) {
        this.validationJob.setValidationIssueProcessor(validationIssueProcessor);
    }

    public void dispose() {
        if (this.validationJob != null) {
            this.validationJob.cancel();
        }
    }
}

