/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.wizards;

import com.yakindu.base.base.BasePackage;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.ui.editor.DiagramActivator;
import java.net.URL;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DomainWizardPage
extends WizardPage {
    private ComboViewer domainCombo;
    private Object domainDescriptors;
    private Browser browser;
    private boolean domainSelected = false;

    protected DomainWizardPage(String pageName) {
        this(pageName, DomainRegistry.getDomains());
    }

    protected DomainWizardPage(String pageName, List<IDomain> domainDescriptors) {
        super(pageName);
        this.domainDescriptors = domainDescriptors;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.domainCombo = new ComboViewer(composite, 8);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.domainCombo.getCombo());
        this.domainCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.domainCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IDomain)element).getName();
            }

            public Image getImage(Object element) {
                IDomain domain = DomainWizardPage.this.unwrap(DomainWizardPage.this.domainCombo.getSelection());
                ImageRegistry imageRegistry = DiagramActivator.getDefault().getImageRegistry();
                Image image = imageRegistry.get(domain.getImagePath().toString());
                if (image == null) {
                    imageRegistry.put(domain.getImagePath().toString(), ImageDescriptor.createFromURL((URL)domain.getImagePath()).createImage());
                }
                return imageRegistry.get(domain.getImagePath().toString());
            }
        });
        this.domainCombo.setInput(this.domainDescriptors);
        Composite composite2 = new Composite(composite, 2048);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite2.setLayout((Layout)new FillLayout());
        this.browser = new Browser(composite2, 0);
        this.domainCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                URL url = DomainWizardPage.this.unwrap(DomainWizardPage.this.domainCombo.getSelection()).getDocumentationProvider().getDocumentationURL();
                if (url != null) {
                    DomainWizardPage.this.browser.setUrl(url.toString());
                }
            }
        });
        this.setControl((Control)composite);
    }

    private void trySelectDefaultDomain() {
        try {
            this.domainCombo.setSelection((ISelection)new StructuredSelection((Object)DomainRegistry.getDomain((String)BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral())));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.trySelectDefaultDomain();
        }
        this.domainSelected = true;
        super.setVisible(visible);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.domainSelected;
    }

    public String getDomainID() {
        return this.unwrap(this.domainCombo.getSelection()).getDomainID();
    }

    protected IDomain unwrap(ISelection selection) {
        IDomain domain = (IDomain)((StructuredSelection)selection).getFirstElement();
        return domain;
    }
}

