/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.wizards;

import com.yakindu.base.base.BasePackage;
import com.yakindu.sct.ui.editor.StatechartImages;
import com.yakindu.sct.ui.editor.wizards.CreationWizard;
import com.yakindu.sct.ui.editor.wizards.DiagramCreator;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class NewStatechartProjectWizard
extends Wizard
implements INewWizard {
    private static final String STATECHART_NAME = "Statechart.ysc";
    private WizardNewProjectCreationPage mainPage;
    private Resource diagram;
    private IProject newProject;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("New itemis CREATE Statechart Project");
    }

    public void addPages() {
        this.initProjectCreationPage();
    }

    protected void initProjectCreationPage() {
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        this.mainPage.setTitle("Project");
        this.mainPage.setDescription("Create a new project resource.");
        this.mainPage.setImageDescriptor(StatechartImages.LOGO.imageDescriptor());
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        if (this.createNewProject()) {
            return this.createNewStatechart();
        }
        return false;
    }

    private boolean createNewProject() {
        IProject newProjectHandle = this.mainPage.getProjectHandle();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(this.mainPage.getLocationURI());
        IRunnableWithProgress op = monitor -> {
            CreateProjectOperation op1 = new CreateProjectOperation(description, "New Project");
            try {
                op1.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
            }
            catch (ExecutionException e) {
                throw new InvocationTargetException(e);
            }
        };
        try {
            this.getContainer().run(false, true, op);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.newProject = newProjectHandle;
        return true;
    }

    protected boolean createNewStatechart() {
        final CreationWizard.DiagramCreationDesccription create = this.getDiagramDescription();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                NewStatechartProjectWizard.this.diagram = new DiagramCreator().createDiagram(create, monitor);
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return this.diagram != null;
    }

    protected CreationWizard.DiagramCreationDesccription getDiagramDescription() {
        URI uri = this.getModelURI();
        String domainID = BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral();
        return new CreationWizard.DiagramCreationDesccription(uri, domainID);
    }

    public URI getModelURI() {
        return URI.createPlatformResourceURI((String)URI.encodeFragment((String)this.getModelFilePath().toString(), (boolean)true), (boolean)false);
    }

    private IPath getModelFilePath() {
        if (this.newProject != null) {
            return this.newProject.getFile(STATECHART_NAME).getFullPath();
        }
        return null;
    }
}

