/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.editor;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.yakindu.base.base.DomainElement;
import com.yakindu.base.xtext.utils.gmf.resource.DirtyStateListener;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.DomainStatus;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.model.sgraph.SpecificationElement;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.ui.editor.DiagramActivator;
import com.yakindu.sct.ui.editor.definitionsection.StatechartDefinitionSection;
import com.yakindu.sct.ui.editor.editor.DomainStatusLabel;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningEditor;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import com.yakindu.sct.ui.editor.proposals.ContentProposalViewerKeyHandler;
import com.yakindu.sct.ui.editor.providers.ISCTOutlineFactory;
import com.yakindu.sct.ui.editor.validation.IValidationIssueStore;
import com.yakindu.sct.ui.editor.validation.LiveValidationListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.DiagramGraphicalViewerKeyHandler;
import org.eclipse.gmf.runtime.gef.ui.internal.editparts.AnimatableZoomManager;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.XtextProjectHelper;

public class StatechartDiagramEditor
extends DiagramPartitioningEditor
implements IGotoMarker {
    public static final String ID = "org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor";
    protected static final int INITIAL_PALETTE_SIZE = 175;
    private KeyHandler keyHandler;
    private DirtyStateListener domainAdapter;
    private LiveValidationListener validationListener;
    private IValidationIssueStore issueStore;
    private StatechartDefinitionSection definitionSection;

    public StatechartDiagramEditor() {
        super(true);
    }

    public void addNature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "org.eclipse.xtext.ui.shared.xtextNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void checkXtextNature() {
        IFileEditorInput editorInput = (IFileEditorInput)this.getEditorInput();
        if (editorInput == null || editorInput.getFile() == null) {
            return;
        }
        IProject project = editorInput.getFile().getProject();
        if (project != null && !XtextProjectHelper.hasNature((IProject)project) && project.isAccessible() && !project.isHidden()) {
            this.addNature(project);
        }
    }

    @Override
    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.disableAnimatedZoom();
        this.createContentProposalViewerKeyHandler();
        super.constructPaletteViewer();
    }

    @Override
    protected void createBreadcrumbViewer(Composite parent) {
        DomainStatus domainStatus = this.getDomainStatus();
        if (domainStatus != null && domainStatus.getSeverity() != DomainStatus.Severity.OK) {
            this.createStatusLabel(parent, domainStatus);
        }
        super.createBreadcrumbViewer(parent);
    }

    protected void createContentProposalViewerKeyHandler() {
        ContentProposalViewerKeyHandler contentProposalHandler = new ContentProposalViewerKeyHandler(this.getGraphicalViewer());
        contentProposalHandler.setParent(new DiagramGraphicalViewerKeyHandler(this.getGraphicalViewer()).setParent(this.getKeyHandler()));
        this.getGraphicalViewer().setKeyHandler((KeyHandler)contentProposalHandler);
    }

    protected TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain domain = DiagramPartitioningUtil.getSharedDomain();
        this.domainAdapter = new DirtyStateListener();
        domain.addResourceSetListener((ResourceSetListener)this.domainAdapter);
        return domain;
    }

    @Override
    protected void createGraphicalViewer(Composite parent) {
        super.createGraphicalViewer(parent);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp(this.getGraphicalViewer().getControl(), "com.yakindu.sct.ui.editor.sc_editor_graphical_viewer");
    }

    protected Object createOutline(Class<?> type) {
        boolean outlineBindingExists;
        Injector editorInjector = this.getEditorInjector();
        boolean bl = outlineBindingExists = editorInjector.getExistingBinding(Key.get(ISCTOutlineFactory.class)) != null;
        if (!outlineBindingExists) {
            return super.getAdapter(type);
        }
        ISCTOutlineFactory outlineFactory = (ISCTOutlineFactory)editorInjector.getInstance(ISCTOutlineFactory.class);
        return outlineFactory.createOutline(this);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.toggleDefinitionSection();
    }

    protected void createStatusLabel(Composite parent, DomainStatus domainStatus) {
        DomainStatusLabel label = new DomainStatusLabel(domainStatus, parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        parent.pack(true);
    }

    @Override
    protected void createTextEditor(Composite parent) {
        if (this.isStatechart()) {
            this.definitionSection = new StatechartDefinitionSection(parent, 2048, this);
        }
    }

    protected void disableAnimatedZoom() {
        AnimatableZoomManager zoomManager = (AnimatableZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        zoomManager.setZoomAnimationStyle(0);
    }

    @Override
    public void dispose() {
        if (this.definitionSection != null && !this.definitionSection.isDisposed()) {
            this.definitionSection.dispose();
        }
        if (this.validationListener != null) {
            this.validationListener.dispose();
        }
        if (this.issueStore != null && !this.getEditorWithSameResource().isPresent()) {
            this.issueStore.disconnect(this.getDiagram().eResource());
        }
        this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.validationListener);
        this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.domainAdapter);
        if (this.domainAdapter != null) {
            this.domainAdapter.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (this.definitionSection != null) {
            this.definitionSection.validateEmbeddedEditorContext();
        }
        super.doSave(progressMonitor);
    }

    protected boolean equalsLocationURI(IEditorInput otherInput, IEditorInput thisInput) {
        URI otherLocationURI = this.getURIForInput(otherInput);
        URI thisLocationURI = this.getURIForInput(thisInput);
        return otherLocationURI != null && otherLocationURI.equals(thisLocationURI);
    }

    protected URI getURIForInput(IEditorInput input) {
        if (input instanceof IURIEditorInput) {
            return ((IURIEditorInput)input).getURI();
        }
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getLocationURI();
        }
        return null;
    }

    @Override
    public Object getAdapter(Class type) {
        if (IContentOutlinePage.class.equals((Object)type)) {
            return this.createOutline(type);
        }
        if (IValidationIssueStore.class.equals((Object)type)) {
            return this.issueStore;
        }
        if (EObject.class.equals((Object)type)) {
            return this.getContextObject();
        }
        if (TransactionalEditingDomain.class.equals((Object)type)) {
            return this.getTransactionalEditingDomain();
        }
        if (Diagram.class.equals((Object)type)) {
            return this.getDiagram();
        }
        if (DiagramEditPart.class.equals((Object)type)) {
            return this.getDiagramEditPart();
        }
        return super.getAdapter(type);
    }

    @Override
    public EObject getContextObject() {
        if (this.getDiagram() == null || this.getDiagram().getElement() == null) {
            return null;
        }
        EObject element = this.getDiagram().getElement();
        return element;
    }

    public String getContributorId() {
        return ID;
    }

    protected DomainStatus getDomainStatus() {
        EObject element = this.getDiagram().getElement();
        DomainElement domainElement = (DomainElement)EcoreUtil2.getContainerOfType((EObject)element, DomainElement.class);
        if (domainElement != null) {
            DomainStatus domainStatus = DomainRegistry.getDomainStatus((String)domainElement.getDomainID());
            return domainStatus;
        }
        return null;
    }

    protected Injector getEditorInjector() {
        IDomain domain = DomainRegistry.getDomain((EObject)this.getDiagram().getElement());
        Injector injector = domain.getInjector("com.yakindu.sct.editor", new String[0]);
        return injector;
    }

    protected Optional<IEditorPart> getEditorWithSameResource() {
        ArrayList currentEditors = Lists.newArrayList((Object[])PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences());
        Optional<IEditorPart> editorWithSameResource = currentEditors.stream().filter(e -> {
            try {
                IEditorInput otherInput = e.getEditorInput();
                IEditorInput thisInput = this.getEditorInput();
                return ID.equals(e.getId()) && !otherInput.equals(thisInput) && this.equalsLocationURI(otherInput, thisInput);
            }
            catch (PartInitException e1) {
                e1.printStackTrace();
                return false;
            }
        }).map(e -> e.getEditor(false)).findFirst();
        return editorWithSameResource;
    }

    protected int getInitialPaletteSize() {
        return 175;
    }

    protected IValidationIssueStore getIssueStore() {
        Optional<IEditorPart> editorWithSameResource = this.getEditorWithSameResource();
        if (editorWithSameResource.isPresent()) {
            IValidationIssueStore sharedStore = (IValidationIssueStore)editorWithSameResource.get().getAdapter(IValidationIssueStore.class);
            return sharedStore;
        }
        IValidationIssueStore newStore = (IValidationIssueStore)this.getEditorInjector().getInstance(IValidationIssueStore.class);
        newStore.connect(this.getDiagram().eResource());
        return newStore;
    }

    protected KeyHandler getKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
            this.registerZoomActions();
            this.keyHandler.put(KeyStroke.getPressed((char)'+', (int)16777259, (int)SWT.MOD1), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
            this.keyHandler.put(KeyStroke.getPressed((char)'-', (int)16777261, (int)SWT.MOD1), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
            this.keyHandler.put(KeyStroke.getPressed((char)'-', (int)45, (int)SWT.MOD1), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
            this.keyHandler.put(KeyStroke.getPressed((char)'=', (int)61, (int)SWT.MOD1), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
            this.keyHandler.put(KeyStroke.getPressed((char)'+', (int)43, (int)SWT.MOD1), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
            this.keyHandler.put(KeyStroke.getPressed((char)'\u001d', (int)43, (int)SWT.MOD1), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
            this.keyHandler.put(KeyStroke.getPressed((char)'0', (int)48, (int)SWT.MOD1), (IAction)new Action(){

                public void run() {
                    StatechartDiagramEditor.this.resetZoom();
                }
            });
            this.keyHandler.put(KeyStroke.getPressed((char)'0', (int)0x1000030, (int)SWT.MOD1), (IAction)new Action(){

                public void run() {
                    StatechartDiagramEditor.this.resetZoom();
                }
            });
        }
        return this.keyHandler;
    }

    protected PreferencesHint getPreferencesHint() {
        return DiagramActivator.DIAGRAM_PREFERENCES_HINT;
    }

    protected TransactionalEditingDomain getTransactionalEditingDomain() {
        return TransactionUtil.getEditingDomain((EObject)this.getDiagram());
    }

    public void gotoMarker(IMarker marker) {
        MarkerNavigationService.getInstance().gotoMarker((IEditorPart)this, marker);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.checkXtextNature();
        this.registerValidationListener();
    }

    public boolean isDirty() {
        if (this.getDiagram() == null || !(this.getContextObject() instanceof SpecificationElement)) {
            return super.isDirty();
        }
        SpecificationElement contextObject = (SpecificationElement)this.getContextObject();
        return super.isDirty() || this.definitionSection != null && this.definitionSection.getDefinition() != null && !this.definitionSection.getDefinition().equals(contextObject.getSpecification());
    }

    public boolean isEditable() {
        DomainStatus domainStatus = this.getDomainStatus();
        if (domainStatus == null || domainStatus.getSeverity() == DomainStatus.Severity.ERROR) {
            return false;
        }
        return super.isEditable();
    }

    protected boolean isStatechart() {
        return this.getContextObject() instanceof Statechart;
    }

    protected void registerValidationListener() {
        this.issueStore = this.getIssueStore();
        this.validationListener = (LiveValidationListener)((Object)this.getEditorInjector().getInstance(LiveValidationListener.class));
        this.validationListener.setResource(this.getDiagram().eResource());
        this.validationListener.setValidationIssueProcessor(this.issueStore);
        this.getEditingDomain().addResourceSetListener((ResourceSetListener)this.validationListener);
        this.validationListener.scheduleValidation();
    }

    protected void registerZoomActions() {
        ZoomInAction action = new ZoomInAction(this.getZoomManager());
        action.setText("");
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ZoomOutAction(this.getZoomManager());
        action.setText("");
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    protected void resetZoom() {
        ZoomManager manager = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        if (manager != null) {
            manager.setZoom(1.0);
        }
    }

    public void toggleDefinitionSection() {
        if (this.definitionSection != null && !this.definitionSection.isDisposed() && this.isStatechart()) {
            this.definitionSection.updateStyle();
            this.definitionSection.restoreSashWidths();
        }
    }
}

