/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.image;

import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.generator.core.ISGraphGenerator;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Statechart;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.generator.IFileSystemAccess;

public class ImageGenerator
implements ISGraphGenerator {
    @Inject
    private ICoreLibraryHelper libraryHelper;
    @Inject
    private CopyToImageUtil renderer;

    public void generate(Statechart statechart, GeneratorEntry entry, IFileSystemAccess fsa) {
        String format = entry.getFeatureParameterValue("Renderer", "format").getStringValue();
        String targetProject = this.libraryHelper.getTargetProjectValue(entry).getStringValue();
        String targetfolder = this.libraryHelper.getTargetFolderValue(entry).getStringValue();
        IFolder targetFolder = this.createTargetFolder(targetProject, targetfolder);
        Collection diagrams = EcoreUtil.getObjectsByType((Collection)statechart.eResource().getContents(), (EClassifier)NotationPackage.Literals.DIAGRAM);
        int counter = 0;
        for (Diagram diagram : diagrams) {
            byte[] result = this.renderImage(diagram, format);
            ByteArrayInputStream source = new ByteArrayInputStream(result);
            IFile file = targetFolder.getFile(((NamedElement)diagram.getElement()).getName() + "_" + counter++ + "." + format);
            try {
                if (file.exists()) {
                    file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                file.create((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected IFolder createTargetFolder(String targetProject, String targetfolder) {
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getProject(targetProject).getFolder((IPath)new Path(targetfolder));
        if (!folder.exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return folder;
    }

    public byte[] renderImage(final Diagram diagram, final String format) {
        RunnableWithResult<byte[]> runnable = new RunnableWithResult<byte[]>(){
            private byte[] result;
            private IStatus status = Status.OK_STATUS;

            public void run() {
                try {
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
                    if (editingDomain == null) {
                        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(diagram.eResource().getResourceSet());
                    }
                    this.result = ImageGenerator.this.renderer.copyToImageByteArray(diagram, -1, -1, ImageFileFormat.resolveImageFormat((String)format.toUpperCase()), (IProgressMonitor)new NullProgressMonitor(), PreferencesHint.USE_DEFAULTS, false);
                }
                catch (Throwable t) {
                    this.setStatus((IStatus)new Status(4, "com.yakindu.sct.generator.image", t.getMessage()));
                }
            }

            public byte[] getResult() {
                return this.result;
            }

            public void setStatus(IStatus status) {
                this.status = status;
            }

            public IStatus getStatus() {
                return this.status;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (byte[])runnable.getResult();
    }
}

