/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt;

import com.xformation.lmx.LmxFeatureInfo;
import com.xformation.lmx.LmxLicenseInfo;
import com.xformation.lmx.LmxLicenseType;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.internal.ILicenseSettings;
import com.yakindu.licmgmt.internal.LicenseService;
import com.yakindu.licmgmt.internal.utils.DateUtils;
import java.util.Date;

public enum LicenseStatus {
    VALID("In use"),
    BORROWED("Borrowed"),
    EXPIRED("Expired"),
    UNKNOWN("Unknown"),
    UNUSED("Not used"),
    MISSING("Missing"),
    DEACTIVATED("Deactivated"),
    UNCHECKED("Not checked");

    public final String text;

    private LicenseStatus(String text) {
        this.text = text;
    }

    public static LicenseStatus create(ILicenseManager licenseManager) {
        if (licenseManager == null) {
            return UNKNOWN;
        }
        if (!licenseManager.isEnabled()) {
            return DEACTIVATED;
        }
        if (!licenseManager.isCheckedOut() && !licenseManager.isAcquireRequested()) {
            return UNCHECKED;
        }
        LmxFeatureInfo featureInfo = licenseManager.getFeatureInfo();
        if (featureInfo == null) {
            return LicenseStatus.checkStatusOfFoundLicenseFeatures(licenseManager);
        }
        if (licenseManager.getExpireTime() == -1) {
            return EXPIRED;
        }
        if (!licenseManager.isCheckedOut()) {
            return UNUSED;
        }
        return LicenseStatus.create(featureInfo);
    }

    private static LicenseStatus checkStatusOfFoundLicenseFeatures(ILicenseManager licenseManager) {
        ILicenseSettings settings = ((LicenseService)ILicenseService.INSTANCE).getSettings();
        for (LmxLicenseInfo licenseInfo : licenseManager.getLicenseInfos()) {
            for (LmxFeatureInfo fInfo : licenseInfo.getFeatures()) {
                if (!fInfo.getFeatureName().equals(licenseManager.getFeatureId())) continue;
                if (licenseManager.getExpireTime() == -2) {
                    return UNUSED;
                }
                String actualExpireTime = fInfo.getActualExpireTime();
                Date expireDate = DateUtils.convertActualExpireTime(actualExpireTime);
                Date currentDate = new Date();
                if (expireDate == null || !currentDate.before(expireDate) || fInfo.getLicenseType() == LmxLicenseType.LMX_TYPE_TRIAL && !settings.isTrialEnabled()) continue;
                return UNUSED;
            }
        }
        return MISSING;
    }

    private static LicenseStatus create(LmxFeatureInfo featureInfo) {
        switch (featureInfo.getLicenseType()) {
            case LMX_TYPE_LOCAL: 
            case LMX_TYPE_NETWORK: 
            case LMX_TYPE_GRACE: 
            case LMX_TYPE_TRIAL: {
                return VALID;
            }
            case LMX_TYPE_BORROW: {
                return BORROWED;
            }
        }
        return UNKNOWN;
    }
}

