/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal;

import java.util.StringTokenizer;

public class LicenseVersion
implements Comparable<LicenseVersion> {
    private final int major;
    private final int minor;
    private final int micro;

    public LicenseVersion(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public LicenseVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getVersionString() {
        return String.valueOf(this.major) + "." + this.minor;
    }

    public static LicenseVersion createLicenseVersion(String versionString) {
        block4: {
            StringTokenizer tokenizer = new StringTokenizer(versionString, ".");
            try {
                if (!tokenizer.hasMoreTokens()) break block4;
                int major = Integer.parseInt(tokenizer.nextToken());
                if (!tokenizer.hasMoreTokens()) break block4;
                int minor = Integer.parseInt(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    int micro = Integer.parseInt(tokenizer.nextToken());
                    if (!tokenizer.hasMoreTokens()) {
                        return new LicenseVersion(major, minor, micro);
                    }
                    break block4;
                }
                return new LicenseVersion(major, minor);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Unable to parse version string '" + versionString + "'", nfe);
            }
        }
        throw new IllegalArgumentException("invalid version format: '" + versionString + "'");
    }

    @Override
    public int compareTo(LicenseVersion other) {
        if (other == null) {
            return 1;
        }
        if (this.getMajor() != other.getMajor()) {
            return this.getMajor() - other.getMajor();
        }
        if (this.getMinor() != other.getMinor()) {
            return this.getMinor() - other.getMinor();
        }
        if (this.getMicro() != other.getMicro()) {
            return this.getMicro() - other.getMicro();
        }
        return 0;
    }
}

