/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal.events;

import com.xformation.lmx.LmxException;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.internal.LicenseManager;
import com.yakindu.licmgmt.internal.events.LicenseEvent;

public class LicenseWarningEvent
extends LicenseEvent {
    private final String title;

    private LicenseWarningEvent(String title, String text) {
        this(title, text, null);
    }

    private LicenseWarningEvent(String title, String text, String featureId) {
        super(text, featureId);
        if (title == null) {
            throw new IllegalArgumentException("Title must not be null");
        }
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public static LicenseEvent create(String title, String message) {
        return new LicenseWarningEvent(title, message);
    }

    public static LicenseEvent createRestartRequired() {
        return new LicenseWarningEvent("Restart required", "Please restart the application to apply the changes.");
    }

    public static LicenseEvent createForSoonExpiringLicense(ILicenseManager licenseManager) {
        int expireTime = licenseManager.getExpireTime();
        if (expireTime < 0) {
            throw new IllegalStateException("In this case, either a license IS already expired, or never will.");
        }
        String title = "License '" + licenseManager.getFeatureId() + "' will expire soon!";
        return new LicenseWarningEvent(title, LicenseWarningEvent.getExpireMessage(expireTime), licenseManager.getFeatureId());
    }

    private static String getExpireMessage(int expireTime) {
        if (expireTime == 0) {
            return "License will expire within this hour!";
        }
        if (expireTime < 24) {
            return "License will expire within " + expireTime + (expireTime == 1 ? " hour. " : " hours.");
        }
        if (expireTime == 24) {
            return "License will expire within one day.";
        }
        int days = expireTime / 24;
        return "License will expire within " + days + (days == 1 ? " day." : " days.");
    }

    public static LicenseEvent createForSingleHeartbeatFailure(LmxException e, long intervalInSeconds) {
        String text = String.format("License server (%s) not reachable:\n%s\nTrying again in %d seconds...", ILicenseService.INSTANCE.getServerSettings().getServerUrl(), e.getErrorStrSimple(), intervalInSeconds);
        return new LicenseWarningEvent("License Server connection unstable", text);
    }

    public static LicenseEvent createForSingleDongleFailure(LmxException e, String featureId, long intervalInSeconds) {
        String text = String.format("Could not find dongle for license %s:\n%s\nTrying again in %d seconds...", featureId, e.getErrorStrSimple(), intervalInSeconds);
        return new LicenseWarningEvent("Dongle not found", text, featureId);
    }

    public static LicenseEvent createForSuccessfulCheckin(LicenseManager licenseManager) {
        String title = "Issue while returning license " + licenseManager.getFeatureId();
        return new LicenseWarningEvent(title, licenseManager.getSimpleErrorMessage(), licenseManager.getFeatureId());
    }

    public static LicenseEvent createForFailedCheckin(LicenseManager licenseManager) {
        String title = "Failed to return license " + licenseManager.getFeatureId();
        return new LicenseWarningEvent(title, licenseManager.getSimpleErrorMessage(), licenseManager.getFeatureId());
    }
}

