/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtils {
    private static final SimpleDateFormat ACTUAL_EXPIRE_TIME_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final long HALF_HOUR = 1800000L;

    public static Date convertActualExpireTime(String dateAsString) {
        try {
            if (dateAsString != null && !dateAsString.isEmpty()) {
                return ACTUAL_EXPIRE_TIME_DATE_FORMAT.parse(dateAsString);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("invalid parameters: " + e.getMessage());
        }
        return null;
    }

    public static long getDaysFromMillis(long millis) {
        return (millis + 1800000L) / 86400000L;
    }

    public static long getHoursFromMillis(long millis) {
        return (millis + 1800000L) / 3600000L;
    }

    public static String getDaysHoursText(long millis) {
        String hourString;
        long days = DateUtils.getDaysFromMillis(millis);
        if (days >= 7L) {
            return String.valueOf(days) + " days";
        }
        String dayString = days == 1L ? "day" : "days";
        long hours = DateUtils.getHoursFromMillis(millis) % 24L;
        String string = hourString = hours == 1L ? "hour" : "hours";
        if (days >= 1L) {
            return String.valueOf(days) + " " + dayString + " " + hours + " " + hourString;
        }
        return String.valueOf(hours) + " " + hourString;
    }
}

