/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.create.sctunit.generator.csharp;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.itemis.create.base.generator.core.artifacts.IContent;
import com.itemis.create.base.generator.core.artifacts.IGenArtifact;
import com.itemis.create.base.generator.csharp.artifacts.CSharpFile;
import com.itemis.create.base.generator.csharp.codemodel.CsharpCompilationUnit;
import com.itemis.create.sctunit.transformation.SCTUnit2SUnitTransformation;
import com.itemis.create.statechart.generator.csharp.transformation.SctTypes2CsharpTypesTransformation;
import com.itemis.create.sunit.generator.csharp.nunit.codemodel.NUnitAnnotations;
import com.itemis.create.sunit.generator.csharp.nunit.transformation.SUnit2NunitTransformation;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Package;
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sctunit.generator.base.ISCTUnitGenerator;
import com.yakindu.sctunit.generator.base.SCTUnitGenmodelEntries;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class CsharpSCTUnitGenerator
implements ISCTUnitGenerator {
    @Inject
    @Extension
    protected SCTUnitGenmodelEntries _sCTUnitGenmodelEntries;
    @Inject
    private IGenArtifactConfigurations locations;
    @Inject
    protected ICoreLibraryHelper helper;
    @Inject
    protected Provider<CSharpFile> fileProvider;
    @Inject
    protected Provider<SCTUnit2SUnitTransformation> sctUnit2SUnitProvider;
    @Inject
    protected Provider<SUnit2NunitTransformation> sUnit2NUnitProvider;
    @Inject
    protected Provider<SctTypes2CsharpTypesTransformation> sctTypes2CsharpTypesProvider;
    @Inject
    @Extension
    protected CsharpCompilationUnit _csharpCompilationUnit;
    @Inject
    @Extension
    protected NUnitAnnotations _nUnitAnnotations;

    public void generate(GeneratorEntry entry, IFileSystemAccess fsa) {
        this.initGenerationArtifacts(entry, fsa);
        this.generateArtifacts(entry, fsa, this.locations);
    }

    public void initGenerationArtifacts(GeneratorEntry entry, IFileSystemAccess fsa) {
        Package sunitPackage = (Package)((SCTUnit2SUnitTransformation)((Object)this.sctUnit2SUnitProvider.get())).transform(this.sctUnitPackage(entry));
        Package nunitPackage = (Package)((SUnit2NunitTransformation)((Object)this.sUnit2NUnitProvider.get())).transform(sunitPackage);
        Functions.Function1 _function = it -> this._nUnitAnnotations.isTestFixture((ComplexType)it);
        ComplexType nunitTest = (ComplexType)IteratorExtensions.head((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)nunitPackage.eAllContents(), ComplexType.class), (Functions.Function1)_function));
        Consumer<Operation> _function_1 = op -> ((SctTypes2CsharpTypesTransformation)this.sctTypes2CsharpTypesProvider.get()).substitueStateEnumMethodMember((Declaration)op, nunitTest);
        Iterables.filter((Iterable)nunitTest.getFeatures(), Operation.class).forEach(_function_1);
        Functions.Function1 _function_2 = it -> this._csharpCompilationUnit.isCompilationUnit(it);
        Procedures.Procedure1 _function_3 = pkg -> {
            CSharpFile _get = (CSharpFile)this.fileProvider.get();
            Procedures.Procedure1 _function_4 = it -> {
                it.setCompilationUnit(pkg);
                this.locations.configure(it.fileName(), "DEFAULT_OUTPUT", (IGenArtifact)it);
            };
            ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function_4);
        };
        IteratorExtensions.forEach((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)nunitPackage.eAllContents(), Package.class), (Functions.Function1)_function_2), (Procedures.Procedure1)_function_3);
    }

    public void generateArtifacts(GeneratorEntry entry, IFileSystemAccess fsa, IGenArtifactConfigurations locations) {
        List _configurations = locations.getConfigurations();
        for (IGenArtifactConfigurations.GenArtifactConfiguration a : _configurations) {
            boolean _not;
            boolean _skip = a.getSkip();
            boolean bl = _not = !_skip;
            if (!_not) continue;
            fsa.generateFile(a.getName(), a.getOutputName(), (CharSequence)this.fileContent(a.getArtifact()));
        }
    }

    protected String _fileContent(IContent it) {
        return it.content();
    }

    protected String _fileContent(Object it) {
        return "";
    }

    public TestPackage sctUnitPackage(GeneratorEntry entry) {
        EObject _eContainer = entry.getElementRef().eContainer();
        return (TestPackage)_eContainer;
    }

    @XbaseGenerated
    public String fileContent(Object it) {
        if (it instanceof IContent) {
            return this._fileContent((IContent)it);
        }
        if (it != null) {
            return this._fileContent(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

