/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.license.domain;

import com.yakindu.sct.domain.extension.DomainStatus;
import com.yakindu.sct.domain.extension.IDomainStatusProvider;
import com.yakindu.sct.license.LicenseChecker;
import com.yakindu.sct.license.LicenseStatus;
import com.yakindu.sct.license.domain.ILicenseStatusLinkHandler;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractDomainStatusProvider
implements IDomainStatusProvider {
    private static final String NO_LICENSE_MSG = "No valid license found! Click <a>here</a> for more information.";
    private static final String NO_LICENSE_SMSG = "No valid license found!";
    private static final String DISABLED_LICENSE_MSG = "License check is disabled! Please enable it on the 'itemis CREATE Licenses' preference page.";
    private static final String LINK_HANDLER_EXT_POINT_ID = "com.yakindu.sct.license.licenseStatusLinkHandler";
    private static final String LINK_HANDLER_EXT_POINT_HANDLER = "handler";

    protected abstract String getRequiredLicense();

    protected LicenseStatus checkLicense() {
        if ("com_yakindu_sct_professional".equals(this.getRequiredLicense())) {
            return new LicenseChecker().checkProfessionalLicense();
        }
        return new LicenseChecker().checkStandardLicense();
    }

    public DomainStatus getDomainStatus() {
        return this.createDomainStatus(this.checkLicense());
    }

    protected DomainStatus createDomainStatus(LicenseStatus licenseStatus) {
        switch (licenseStatus.getStatus()) {
            case ERROR: {
                return new DomainStatus(DomainStatus.Severity.ERROR, licenseStatus.getMessage());
            }
            case EXPIRED: 
            case NON_EXISTING: {
                return new DomainStatus(DomainStatus.Severity.ERROR, NO_LICENSE_MSG, NO_LICENSE_SMSG, this.getLinkHandler(this.getRequiredLicense()));
            }
            case DISABLED: {
                return new DomainStatus(DomainStatus.Severity.ERROR, DISABLED_LICENSE_MSG);
            }
        }
        return new DomainStatus(DomainStatus.Severity.OK, licenseStatus.getMessage());
    }

    protected DomainStatus.ILinkHandler getLinkHandler(final String licenseId) {
        return new DomainStatus.ILinkHandler(){

            public void handleLink() {
                Optional<ILicenseStatusLinkHandler> handler = AbstractDomainStatusProvider.this.getLicenseStatusLinkHandler(licenseId);
                if (handler.isPresent()) {
                    handler.get().handle();
                }
            }
        };
    }

    protected Optional<ILicenseStatusLinkHandler> getLicenseStatusLinkHandler(String licenseId) {
        IConfigurationElement[] configurationElements;
        ArrayList<ILicenseStatusLinkHandler> handlers = new ArrayList<ILicenseStatusLinkHandler>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(LINK_HANDLER_EXT_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                ILicenseStatusLinkHandler handler = (ILicenseStatusLinkHandler)element.createExecutableExtension(LINK_HANDLER_EXT_POINT_HANDLER);
                handlers.add(handler);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return handlers.stream().filter(h -> h.isResponsibleFor(licenseId)).findFirst();
    }
}

