/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.formatting;

import com.yakindu.sctunit.services.SCTUnitGrammarAccess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.FormattingConfig;
import org.eclipse.xtext.util.Pair;

public class SCTUnitFormatter
extends AbstractDeclarativeFormatter {
    protected void configureFormatting(FormattingConfig config) {
        SCTUnitGrammarAccess grammar = (SCTUnitGrammarAccess)this.getGrammarAccess();
        SCTUnitGrammarAccess.TestStatementElements testStatements = grammar.getTestStatementAccess();
        SCTUnitGrammarAccess.TestPackageElements testPackage = grammar.getTestPackageAccess();
        SCTUnitGrammarAccess.SCTUnitClassElements sctunitClass = grammar.getSCTUnitClassAccess();
        SCTUnitGrammarAccess.SCTUnitOperationElements operation = grammar.getSCTUnitOperationAccess();
        config.setAutoLinewrap(120);
        this.formatTestPackage(config, testPackage);
        this.formatCurlyBraces(config, grammar);
        this.formatBrackets(config, grammar);
        this.formatAnnotations(config, grammar);
        this.formatRoundBrackets(config, grammar);
        this.formatSCTUnitClass(config, sctunitClass);
        this.formatVoidOperationDefinition(config, operation);
        this.formatTestStatements(config, testStatements);
        this.formatComments(config, grammar);
        this.removeSpacesArroundDots(config, grammar);
        this.removeWhitespaceAfterNegation(config, grammar);
    }

    private void formatTestPackage(FormattingConfig config, SCTUnitGrammarAccess.TestPackageElements testPackage) {
        config.setLinewrap(1, 1, 2).before((EObject)testPackage.getMemberAssignment_2());
    }

    private void formatSCTUnitClass(FormattingConfig config, SCTUnitGrammarAccess.SCTUnitClassElements sctunitClass) {
        config.setLinewrap(1, 1, 2).before((EObject)sctunitClass.getVariableDefinitionsAssignment_7());
        config.setLinewrap(1, 1, 2).before((EObject)sctunitClass.getFeaturesAssignment_8());
    }

    private void formatVoidOperationDefinition(FormattingConfig config, SCTUnitGrammarAccess.SCTUnitOperationElements operation) {
        config.setLinewrap(1, 1, 2).after((EObject)operation.getAnnotationAssignment_1());
    }

    private void formatTestStatements(FormattingConfig config, SCTUnitGrammarAccess.TestStatementElements testStatements) {
        config.setLinewrap(1, 1, 2).before((EObject)testStatements.getExpressionStatementParserRuleCall_0());
        config.setLinewrap(1, 1, 2).before((EObject)testStatements.getMockingStatementParserRuleCall_1());
        config.setLinewrap(1, 1, 2).before((EObject)testStatements.getAssertionStatementParserRuleCall_2());
        config.setLinewrap(1, 1, 2).before((EObject)testStatements.getLoopStatementParserRuleCall_3());
        config.setLinewrap(1, 1, 2).before((EObject)testStatements.getVariableDefinitionStatementParserRuleCall_4());
        config.setLinewrap(1, 1, 2).before((EObject)testStatements.getReturnStatementParserRuleCall_5());
    }

    private void removeSpacesArroundDots(FormattingConfig config, SCTUnitGrammarAccess grammar) {
        for (Keyword keyword : grammar.findKeywords(new String[]{"."})) {
            config.setNoSpace().around((EObject)keyword);
        }
    }

    private void formatComments(FormattingConfig config, SCTUnitGrammarAccess grammar) {
        config.setLinewrap(1, 1, 2).around((EObject)grammar.getML_COMMENTRule());
    }

    private void formatCurlyBraces(FormattingConfig config, SCTUnitGrammarAccess grammar) {
        for (Pair p : grammar.findKeywordPairs("{", "}")) {
            config.setIndentationIncrement().after((EObject)p.getFirst());
            config.setIndentationDecrement().before((EObject)p.getSecond());
            config.setLinewrap().after((EObject)p.getFirst());
            config.setLinewrap().around((EObject)p.getSecond());
        }
    }

    private void formatAnnotations(FormattingConfig config, SCTUnitGrammarAccess grammar) {
        for (Keyword keyword : grammar.findKeywords(new String[]{"@"})) {
            config.setNoSpace().after((EObject)keyword);
        }
    }

    private void formatBrackets(FormattingConfig config, SCTUnitGrammarAccess grammar) {
        for (Keyword keyword : grammar.findKeywords(new String[]{"["})) {
            config.setNoSpace().after((EObject)keyword);
        }
        for (Keyword keyword : grammar.findKeywords(new String[]{"]"})) {
            config.setNoSpace().before((EObject)keyword);
        }
    }

    private void removeWhitespaceAfterNegation(FormattingConfig config, SCTUnitGrammarAccess grammar) {
        config.setNoSpace().after((EObject)grammar.getLogicalNotOperatorRule());
    }

    private void formatRoundBrackets(FormattingConfig config, SCTUnitGrammarAccess grammar) {
        for (Keyword keyword : grammar.findKeywords(new String[]{"("})) {
            config.setNoSpace().after((EObject)keyword);
        }
        for (Keyword keyword : grammar.findKeywords(new String[]{")"})) {
            config.setNoSpace().before((EObject)keyword);
        }
    }
}

