/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.scoping;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.yakindu.base.expressions.expressions.ExpressionsPackage;
import com.yakindu.base.types.Direction;
import com.yakindu.base.types.TypesPackage;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.stext.scoping.ContextPredicateProvider;
import com.yakindu.sct.model.stext.stext.EventDefinition;
import com.yakindu.sct.model.stext.stext.StextPackage;
import com.yakindu.sctunit.sCTUnit.SCTUnitPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class SCTUnitContextPredicateProvider
extends ContextPredicateProvider {
    private static final AllwaysFilterPredicate ALLWAYSPREDICATE = new AllwaysFilterPredicate();
    private static final EverythingExceptInEventsPredicate INEVENTS = new EverythingExceptInEventsPredicate();
    private static final StandardSCTUnitPredicate STANDARD = new StandardSCTUnitPredicate();
    private static final OperationMockingPredicate MOCKING = new OperationMockingPredicate();

    protected static boolean isNotOutEvent(IEObjectDescription input) {
        EventDefinition event = (EventDefinition)input.getEObjectOrProxy();
        return !event.getDirection().equals((Object)Direction.OUT);
    }

    protected Pair<EClass, EReference> key(EClass eClass) {
        return Tuples.create((Object)eClass, null);
    }

    protected Pair<EClass, EReference> key(EClass eClass, EReference ref) {
        return Tuples.create((Object)eClass, (Object)ref);
    }

    protected void initMap() {
        super.initMap();
        this.filter.put(this.key(SCTUnitPackage.Literals.CODE_BLOCK, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), STANDARD);
        this.filter.put(this.key(EcorePackage.Literals.EOBJECT, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), ALLWAYSPREDICATE);
        this.filter.put(this.key(TypesPackage.Literals.EXPRESSION, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), ALLWAYSPREDICATE);
        this.filter.put(this.key(ExpressionsPackage.Literals.EVENT_RAISING_EXPRESSION, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), INEVENTS);
        this.filter.put(this.key(SCTUnitPackage.Literals.RETURN_STATEMENT, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), STANDARD);
        this.filter.put(this.key(SCTUnitPackage.Literals.EXPRESSION_STATEMENT, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), STANDARD);
        this.filter.put(this.key(SCTUnitPackage.Literals.EXPRESSION_STATEMENT, SCTUnitPackage.Literals.EXPRESSION_STATEMENT__EXPRESSION), Predicates.or((Predicate[])new Predicate[]{VARIABLES, OPERATIONS, EVENTS, ENUMERATIONS}));
        this.filter.put(this.key(SCTUnitPackage.Literals.IF_STATEMENT, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), STANDARD);
        this.filter.put(this.key(SCTUnitPackage.Literals.LOOP_STATEMENT, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), STANDARD);
        this.filter.put(this.key(ExpressionsPackage.Literals.EVENT_VALUE_REFERENCE_EXPRESSION, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), INEVENTS);
        this.filter.put(this.key(SCTUnitPackage.Literals.CODE_BLOCK, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), STANDARD);
        this.filter.put(this.key(SCTUnitPackage.Literals.MOCK_RETURN_STATEMENT, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), MOCKING);
        this.filter.put(this.key(SCTUnitPackage.Literals.MOCK_RETURN_STATEMENT, SCTUnitPackage.Literals.MOCKING_STATEMENT__REFERENCE), MOCKING);
        this.filter.put(this.key(SCTUnitPackage.Literals.VERIFY_CALLED_STATEMENT, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), MOCKING);
        this.filter.put(this.key(SCTUnitPackage.Literals.VERIFY_CALLED_STATEMENT, SCTUnitPackage.Literals.MOCKING_STATEMENT__REFERENCE), MOCKING);
        this.filter.put(this.key(ExpressionsPackage.Literals.NUMERICAL_ADD_SUBTRACT_EXPRESSION, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), STANDARD);
        this.filter.put(this.key(SCTUnitPackage.Literals.ASSERTION_STATEMENT, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), ALLWAYSPREDICATE);
        this.filter.put(this.key(SCTUnitPackage.Literals.VARIABLE_DEFINITION_STATEMENT, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), ALLWAYSPREDICATE);
        this.filter.put(this.key(ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), ALLWAYSPREDICATE);
        this.filter.put(this.key(TypesPackage.Literals.ARGUMENT), ALLWAYSPREDICATE);
    }

    public Predicate<IEObjectDescription> getPredicate(EClass clazz, EReference reference) {
        Predicate predicate = super.getPredicate(clazz, reference);
        if (predicate == EMPTY_PREDICATE) {
            return predicate;
        }
        return Predicates.or((Predicate)predicate, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                String isAliasOnEnum = input.getUserData("is_alias_on_enum");
                return isAliasOnEnum != null && Boolean.valueOf(isAliasOnEnum) != false;
            }
        });
    }

    public static class AllwaysFilterPredicate
    implements Predicate<IEObjectDescription> {
        public boolean apply(IEObjectDescription input) {
            return !input.getEClass().equals(SCTUnitPackage.Literals.SCT_UNIT_CLASS) && !input.getEClass().equals(SGraphPackage.Literals.STATECHART) && !input.getEClass().equals(SCTUnitPackage.Literals.TEST_PACKAGE) && !input.getEClass().equals(StextPackage.Literals.OPERATION_DEFINITION);
        }
    }

    public static class EverythingExceptInEventsPredicate
    implements Predicate<IEObjectDescription> {
        public boolean apply(IEObjectDescription input) {
            if (!input.getEClass().equals(StextPackage.Literals.EVENT_DEFINITION)) {
                return false;
            }
            return SCTUnitContextPredicateProvider.isNotOutEvent(input);
        }
    }

    public static class MockReturnPredicate
    implements Predicate<IEObjectDescription> {
        public boolean apply(IEObjectDescription input) {
            return input.getEClass().equals(TypesPackage.Literals.PARAMETER) || input.getEClass().equals(StextPackage.Literals.VARIABLE_DEFINITION);
        }
    }

    public static class OperationMockingPredicate
    implements Predicate<IEObjectDescription> {
        public boolean apply(IEObjectDescription input) {
            return TypesPackage.Literals.OPERATION.isSuperTypeOf(input.getEClass()) && !input.getEClass().equals(SCTUnitPackage.Literals.SCT_UNIT_OPERATION) || input.getEClass().isSuperTypeOf(StextPackage.Literals.VARIABLE_DEFINITION);
        }
    }

    public static class StandardSCTUnitPredicate
    implements Predicate<IEObjectDescription> {
        public boolean apply(IEObjectDescription input) {
            if (input.getEClass().equals(SCTUnitPackage.Literals.SCT_UNIT_OPERATION)) {
                return true;
            }
            if (input.getEClass().equals(StextPackage.Literals.VARIABLE_DEFINITION)) {
                return true;
            }
            if (input.getEClass().equals(TypesPackage.Literals.PARAMETER)) {
                return true;
            }
            if (input.getEClass().equals(StextPackage.Literals.EVENT_DEFINITION)) {
                return SCTUnitContextPredicateProvider.isNotOutEvent(input);
            }
            return false;
        }
    }
}

