/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.scoping;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.scoping.StextImportAwareScopeProvider;
import com.yakindu.sct.model.stext.stext.ImportScope;
import com.yakindu.sctunit.DomainInjectorProvider;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitPackage;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;

public class SCTUnitImportAwareScopeProvider
extends StextImportAwareScopeProvider {
    @Inject
    protected DomainInjectorProvider domainInjectorProvider;

    protected IScope getLocalElementsScope(IScope parent, EObject context, EReference reference) {
        ImportNormalizer localNormalizer;
        IScope result = parent;
        ISelectable allDescriptions = this.getAllDescriptions(context.eResource());
        QualifiedName name = this.getQualifiedNameOfLocalElement(context);
        boolean ignoreCase = this.isIgnoreCase(reference);
        List<ImportNormalizer> namespaceResolvers = this.getNamespaceResolvers(context, reference, ignoreCase);
        if (!namespaceResolvers.isEmpty()) {
            if (this.isRelativeImport() && name != null && !name.isEmpty()) {
                localNormalizer = this.doCreateImportNormalizer(name, true, ignoreCase);
                result = this.createImportScope(result, Collections.singletonList(localNormalizer), allDescriptions, reference.getEReferenceType(), this.isIgnoreCase(reference));
            }
            result = this.createImportScope(result, namespaceResolvers, null, reference.getEReferenceType(), this.isIgnoreCase(reference));
        }
        if (name != null) {
            localNormalizer = this.doCreateImportNormalizer(name, true, ignoreCase);
            result = this.createImportScope(result, Collections.singletonList(localNormalizer), allDescriptions, reference.getEReferenceType(), this.isIgnoreCase(reference));
        }
        return result;
    }

    protected List<ImportNormalizer> getNamespaceResolvers(EObject context, EReference reference, boolean ignoreCase) {
        ArrayList<ImportNormalizer> namespaceResolvers = new ArrayList<ImportNormalizer>();
        if (!reference.equals(SCTUnitPackage.Literals.SCT_UNIT_CLASS__STATECHART) && this.getStatechart(context) != null) {
            namespaceResolvers.addAll(this.getImportedNamespaceResolvers(context, ignoreCase));
            namespaceResolvers.addAll(this.getImportedNamespaceResolvers((EObject)this.getStatechart(context), ignoreCase));
        } else {
            namespaceResolvers.addAll(this.getImportedNamespaceResolvers(context, ignoreCase));
        }
        return namespaceResolvers;
    }

    protected List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        ArrayList importedNamespaceResolvers = Lists.newArrayList();
        List importScopes = null;
        if (context instanceof Statechart) {
            importScopes = EcoreUtil2.getAllContentsOfType((EObject)context, ImportScope.class);
            for (ImportScope scope : importScopes) {
                importedNamespaceResolvers.addAll(this.createNamespaceResolver((Scope)scope, ignoreCase));
            }
        }
        return importedNamespaceResolvers;
    }

    protected Statechart getStatechart(EObject context) {
        TestPackage testPackage;
        if (context instanceof Statechart) {
            return (Statechart)context;
        }
        if (context instanceof SCTUnitClass) {
            return ((SCTUnitClass)context).getStatechart();
        }
        if (context instanceof TestPackage && (testPackage = (TestPackage)context).getMember().get(0) instanceof SCTUnitClass) {
            SCTUnitClass clazz = (SCTUnitClass)testPackage.getMember().get(0);
            return clazz.getStatechart();
        }
        return null;
    }

    protected List<ImportNormalizer> createNamespaceResolver(Scope scope, boolean ignoreCase) {
        ArrayList importedNamespaceResolvers = Lists.newArrayList();
        ImportScope importScope = (ImportScope)scope;
        Statechart statechart = (Statechart)EcoreUtil2.getContainerOfType((EObject)importScope, Statechart.class);
        IPackageImport2URIMapper import2UriMapper = (IPackageImport2URIMapper)this.domainInjectorProvider.getInjector(statechart).getInstance(IPackageImport2URIMapper.class);
        for (String child : importScope.getImports()) {
            ImportNormalizer resolver;
            Optional pkgImport = import2UriMapper.findPackageImport(scope.eResource(), child);
            if (!pkgImport.isPresent() || (resolver = this.createImportedNamespaceResolver(((IPackageImport2URIMapper.PackageImport)pkgImport.get()).getNamespace(), ignoreCase)) == null) continue;
            importedNamespaceResolvers.add(resolver);
        }
        return importedNamespaceResolvers;
    }
}

