/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.validation;

import com.google.common.collect.Iterables;
import com.yakindu.base.base.BasePackage;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.types.Annotation;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import com.yakindu.sctunit.sCTUnit.EnterExpression;
import com.yakindu.sctunit.sCTUnit.ExitExpression;
import com.yakindu.sctunit.sCTUnit.ExpressionStatement;
import com.yakindu.sctunit.sCTUnit.IfStatement;
import com.yakindu.sctunit.sCTUnit.ProceedExpression;
import com.yakindu.sctunit.sCTUnit.ReturnStatement;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import com.yakindu.sctunit.validation.BaseSCTUnitValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;

public class SCTUnitOperationValidator
extends BaseSCTUnitValidator {
    private static final String TEST_ANNOTATION = "Test";

    @Check
    public void checkTestOperationIsVoid(SCTUnitOperation operation) {
        ITypeSystemInferrer ti = this.typeInferrer;
        ITypeSystem ts = this.getTypeSystem((EObject)operation);
        ITypeSystemInferrer.InferenceResult operationResult = ti.infer((EObject)operation, (IValidationIssueAcceptor)this);
        Type operationType = operationResult.getType();
        if (this.checkAnnotationName(operation, TEST_ANNOTATION) && !ts.isSame(operationType, ts.getType("void"))) {
            this.error("A '@Test'-operation must have the type void", (EObject)operation, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkTestHaveNoParameters(SCTUnitOperation operation) {
        if (this.checkAnnotationName(operation, TEST_ANNOTATION) && operation.getParameters() != null && !operation.getParameters().isEmpty()) {
            this.error("A '@Test'-operation must not have parameters", (EObject)operation, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkReturnStatementsAreCompatibleToReturnType(SCTUnitOperation operation) {
        ITypeSystemInferrer.InferenceResult operationType;
        ITypeSystemInferrer ti = this.typeInferrer;
        ITypeSystem ts = this.getTypeSystem((EObject)operation);
        if (ts.isSame((operationType = ti.infer((EObject)operation, (IValidationIssueAcceptor)this)).getType(), ts.getType("void"))) {
            return;
        }
        if (operation.getBody().getCode().isEmpty()) {
            this.error(String.format("The operation must return a value of type %s", operationType), (EObject)operation, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
            return;
        }
        TestStatement lastStatement = (TestStatement)Iterables.getLast(operation.getBody().getCode());
        Type rsType = ti.infer((EObject)lastStatement, (IValidationIssueAcceptor)this).getType();
        if (!ts.isSuperType(operationType.getType(), rsType)) {
            this.error(String.format("The return type '%s' does not match the type of the operation '%s'", rsType, operationType), (EObject)operation, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
            return;
        }
        List returnStatements = EcoreUtil2.getAllContentsOfType((EObject)operation.getBody(), ReturnStatement.class);
        for (ReturnStatement rs : returnStatements) {
            rsType = ti.infer((EObject)rs, (IValidationIssueAcceptor)this).getType();
            if (ts.isSuperType(operationType.getType(), rsType)) continue;
            this.error(String.format("The return type '%s' does not match the type of the operation '%s'", rsType, operationType), rs, null);
        }
    }

    @Check
    public void checkLastStatementOfNonVoidOperationIsReturn(SCTUnitOperation operation) {
        ITypeSystemInferrer.InferenceResult operationType;
        ITypeSystemInferrer ti = this.typeInferrer;
        ITypeSystem ts = this.getTypeSystem((EObject)operation);
        if (ts.isSame((operationType = ti.infer((EObject)operation, (IValidationIssueAcceptor)this)).getType(), ts.getType("void"))) {
            return;
        }
        if (operation.getBody().getCode().isEmpty()) {
            this.error(String.format("The operation must return a value of type %s", operationType), (EObject)operation, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
            return;
        }
        TestStatement lastStatement = (TestStatement)Iterables.getLast(operation.getBody().getCode());
        if (lastStatement instanceof IfStatement) {
            this.checkLastStatementInIfStatementIsReturn((IfStatement)lastStatement);
        } else if (!(lastStatement instanceof ReturnStatement)) {
            this.error("The last statement has to be a return statement", lastStatement, null);
        }
    }

    public void checkLastStatementInIfStatementIsReturn(IfStatement stmt) {
        TestStatement lastTrueStatement = (TestStatement)Iterables.getLast(stmt.getThen().getCode());
        TestStatement lastFalseStatement = null;
        if (stmt.getElse() == null || stmt.getElse().getCode().isEmpty()) {
            this.error("The last statement has to be a return statement", lastTrueStatement, null);
            return;
        }
        lastFalseStatement = (TestStatement)Iterables.getLast(stmt.getElse().getCode());
        if (lastTrueStatement instanceof IfStatement) {
            this.checkLastStatementInIfStatementIsReturn((IfStatement)lastTrueStatement);
        } else if (!(lastTrueStatement instanceof ReturnStatement)) {
            this.error("The last statement has to be a return statement", lastTrueStatement, null);
            return;
        }
        if (lastFalseStatement instanceof IfStatement) {
            this.checkLastStatementInIfStatementIsReturn((IfStatement)lastFalseStatement);
        } else if (!(lastFalseStatement instanceof ReturnStatement)) {
            this.error("The last statement has to be a return statement", lastFalseStatement, null);
        }
    }

    @Check
    public void checkEnterNotAllowedInGuardedExpression(SCTUnitOperation operation) {
        List contents = EcoreUtil2.eAllOfType((EObject)operation, ExpressionStatement.class);
        try {
            for (ExpressionStatement statement : contents) {
                if (!(statement.getExpression() instanceof EnterExpression) || EcoreUtil2.getContainerOfType((EObject)statement.eContainer(), TestStatement.class) == null) continue;
                this.error("'Enter' statement is not allowed in a guarded expression!", statement, null, -1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Check
    public void checkEnterBeforeRunCycle(SCTUnitOperation operation) {
        block8: {
            if (!this.checkAnnotationName(operation, TEST_ANNOTATION)) break block8;
            List contents = EcoreUtil2.eAllOfType((EObject)operation, ExpressionStatement.class);
            ArrayList<Integer> enters = new ArrayList<Integer>();
            for (ExpressionStatement statement : contents) {
                if (statement.getExpression() instanceof EnterExpression) {
                    enters.add(contents.indexOf(statement));
                    continue;
                }
                SCTUnitOperation op = this.getSCTUnitOperationDefOfExprStmt(statement);
                if (op == null || !this.hasTestStatement(op, EnterExpression.class, this.createOperationSet(op))) continue;
                enters.add(contents.indexOf(statement));
            }
            if (enters.size() != 0) {
                for (ExpressionStatement statement : contents) {
                    if (statement.getExpression() instanceof ProceedExpression && contents.indexOf(statement) < (Integer)enters.get(0)) {
                        this.warning("Missing 'enter' statement before 'cycle'!", statement, null, "Missing 'enter' statement before 'cycle'!", new String[0]);
                        continue;
                    }
                    if (contents.indexOf(statement) >= (Integer)enters.get(0)) continue;
                    this.checkOperationHasNoRunCycleAndEnterStatement(statement);
                }
            } else {
                for (ExpressionStatement statement : contents) {
                    if (statement.getExpression() instanceof ProceedExpression) {
                        this.warning("Missing 'enter' statement before 'cycle'!", statement, null, "Missing 'enter' statement before 'cycle'!", new String[0]);
                        continue;
                    }
                    this.checkOperationHasNoRunCycleAndEnterStatement(statement);
                }
            }
        }
    }

    @Check
    public void checkNoExitBeforeCycle(SCTUnitOperation operation) {
        SCTUnitOperation op;
        List contents = EcoreUtil2.eAllOfType((EObject)operation, ExpressionStatement.class);
        ArrayList<Integer> exits = new ArrayList<Integer>();
        for (ExpressionStatement statement : contents) {
            if (statement.getExpression() instanceof ExitExpression) {
                exits.add(contents.indexOf(statement));
                continue;
            }
            op = this.getSCTUnitOperationDefOfExprStmt(statement);
            if (op == null || !this.hasTestStatement(op, ExitExpression.class, this.createOperationSet(op))) continue;
            exits.add(contents.indexOf(statement));
        }
        for (ExpressionStatement statement : contents) {
            if (statement.getExpression() instanceof ProceedExpression) {
                this.checkForCycleAfterExit(statement, exits, contents);
                continue;
            }
            op = this.getSCTUnitOperationDefOfExprStmt(statement);
            if (op == null || !this.hasTestStatement(op, ProceedExpression.class, this.createOperationSet(op)) || this.hasTestStatement(op, EnterExpression.class, this.createOperationSet(op))) continue;
            this.checkForCycleAfterExit(statement, exits, contents);
        }
    }

    protected void checkOperationHasNoRunCycleAndEnterStatement(ExpressionStatement statement) {
        SCTUnitOperation op = this.getSCTUnitOperationDefOfExprStmt(statement);
        if (op != null && this.hasTestStatement(op, ProceedExpression.class, this.createOperationSet(op)) && !this.hasTestStatement(op, EnterExpression.class, this.createOperationSet(op))) {
            this.warning("Missing 'enter' statement before 'cycle'!", statement, null, "Missing 'enter' statement before 'cycle'!", new String[0]);
        }
    }

    protected void checkForCycleAfterExit(ExpressionStatement statement, List<Integer> exits, List<ExpressionStatement> contents) {
        boolean exitBeforeCycle = false;
        Integer nearestExit = -1;
        for (Integer exit : exits) {
            if (contents.indexOf(statement) <= exit) continue;
            exitBeforeCycle = true;
            nearestExit = (int)exit;
        }
        if (exitBeforeCycle) {
            boolean enterNew = false;
            int i = nearestExit;
            while (contents.indexOf(statement) > i) {
                if (contents.get(i).getExpression() instanceof EnterExpression) {
                    enterNew = true;
                }
                ++i;
            }
            if (!enterNew) {
                this.error("'Proceed' after 'exit' without 'enter' in between!", statement, null, "'Proceed' after 'exit' without 'enter' in between!", new String[0]);
            }
        }
    }

    protected SCTUnitOperation getSCTUnitOperationDefOfExprStmt(ExpressionStatement stmt) {
        ElementReferenceExpression expr;
        if (stmt.getExpression() instanceof ElementReferenceExpression && (expr = (ElementReferenceExpression)stmt.getExpression()).getReference() instanceof SCTUnitOperation) {
            SCTUnitOperation op = (SCTUnitOperation)expr.getReference();
            return op;
        }
        return null;
    }

    protected boolean hasTestStatement(SCTUnitOperation operation, Class<? extends Expression> checkStatement, Set<SCTUnitOperation> calledBy) {
        List contents = EcoreUtil2.eAllOfType((EObject)operation, TestStatement.class);
        for (TestStatement statement : contents) {
            if (!(statement instanceof ExpressionStatement)) continue;
            ExpressionStatement exprStmt = (ExpressionStatement)statement;
            if (checkStatement.isInstance(exprStmt.getExpression())) {
                return true;
            }
            SCTUnitOperation op = this.getSCTUnitOperationDefOfExprStmt(exprStmt);
            if (op != null && !EcoreUtil2.equals((EObject)op, (EObject)operation) && !this.alreadyCalled(op, calledBy)) {
                calledBy.add(operation);
                return this.hasTestStatement(op, checkStatement, calledBy);
            }
            if (!this.alreadyCalled(op, calledBy)) continue;
            return false;
        }
        return false;
    }

    protected boolean checkAnnotationName(SCTUnitOperation operation, String name) {
        EList<Annotation> annotations = operation.getAnnotation();
        for (Annotation anno : annotations) {
            if (!anno.getType().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean alreadyCalled(SCTUnitOperation operation, Set<SCTUnitOperation> calledBy) {
        boolean called = false;
        for (SCTUnitOperation sctUnitOperation : calledBy) {
            if (!EcoreUtil2.equals((EObject)sctUnitOperation, (EObject)operation)) continue;
            called = true;
        }
        return called;
    }

    protected Set<SCTUnitOperation> createOperationSet(SCTUnitOperation operation) {
        HashSet<SCTUnitOperation> calledOps = new HashSet<SCTUnitOperation>();
        calledOps.add(operation);
        return calledOps;
    }
}

