/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.hnsw.HnswGraphProvider;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.internal.hppc.IntIntHashMap;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.hnsw.HnswBuilder;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.HnswGraphMerger;
import org.apache.lucene.util.hnsw.MergingHnswGraphBuilder;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;

public class IncrementalHnswGraphMerger
implements HnswGraphMerger {
    protected final FieldInfo fieldInfo;
    protected final RandomVectorScorerSupplier scorerSupplier;
    protected final int M;
    protected final int beamWidth;
    protected List<GraphReader> graphReaders = new ArrayList<GraphReader>();
    private int numReaders = 0;

    public IncrementalHnswGraphMerger(FieldInfo fieldInfo, RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth) {
        this.fieldInfo = fieldInfo;
        this.scorerSupplier = scorerSupplier;
        this.M = M;
        this.beamWidth = beamWidth;
    }

    @Override
    public IncrementalHnswGraphMerger addReader(KnnVectorsReader reader, MergeState.DocMap docMap, Bits liveDocs) throws IOException {
        ++this.numReaders;
        KnnVectorsReader currKnnVectorsReader = reader;
        if (reader instanceof PerFieldKnnVectorsFormat.FieldsReader) {
            PerFieldKnnVectorsFormat.FieldsReader candidateReader = (PerFieldKnnVectorsFormat.FieldsReader)reader;
            currKnnVectorsReader = candidateReader.getFieldReader(this.fieldInfo.name);
        }
        if (!(currKnnVectorsReader instanceof HnswGraphProvider) || !IncrementalHnswGraphMerger.noDeletes(liveDocs)) {
            return this;
        }
        HnswGraph graph = ((HnswGraphProvider)((Object)currKnnVectorsReader)).getGraph(this.fieldInfo.name);
        if (graph == null || graph.size() == 0) {
            return this;
        }
        int candidateVectorCount = 0;
        switch (this.fieldInfo.getVectorEncoding()) {
            case BYTE: {
                ByteVectorValues byteVectorValues = currKnnVectorsReader.getByteVectorValues(this.fieldInfo.name);
                if (byteVectorValues == null) {
                    return this;
                }
                candidateVectorCount = byteVectorValues.size();
                break;
            }
            case FLOAT32: {
                FloatVectorValues vectorValues = currKnnVectorsReader.getFloatVectorValues(this.fieldInfo.name);
                if (vectorValues == null) {
                    return this;
                }
                candidateVectorCount = vectorValues.size();
            }
        }
        this.graphReaders.add(new GraphReader(currKnnVectorsReader, docMap, candidateVectorCount));
        return this;
    }

    protected HnswBuilder createBuilder(KnnVectorValues mergedVectorValues, int maxOrd) throws IOException {
        if (this.graphReaders.size() == 0) {
            return HnswGraphBuilder.create(this.scorerSupplier, this.M, this.beamWidth, HnswGraphBuilder.randSeed, maxOrd);
        }
        this.graphReaders.sort(Comparator.comparingInt(GraphReader::graphSize).reversed());
        FixedBitSet initializedNodes = this.graphReaders.size() == this.numReaders ? null : new FixedBitSet(maxOrd);
        int[][] ordMaps = this.getNewOrdMapping(mergedVectorValues, initializedNodes);
        HnswGraph[] graphs = new HnswGraph[this.graphReaders.size()];
        for (int i = 0; i < this.graphReaders.size(); ++i) {
            HnswGraph graph = ((HnswGraphProvider)((Object)this.graphReaders.get((int)i).reader)).getGraph(this.fieldInfo.name);
            if (graph.size() == 0) {
                throw new IllegalStateException("Graph should not be empty");
            }
            graphs[i] = graph;
        }
        return MergingHnswGraphBuilder.fromGraphs(this.scorerSupplier, this.M, this.beamWidth, HnswGraphBuilder.randSeed, graphs, ordMaps, maxOrd, initializedNodes);
    }

    protected final int[][] getNewOrdMapping(KnnVectorValues mergedVectorValues, BitSet initializedNodes) throws IOException {
        int numGraphs = this.graphReaders.size();
        IntIntHashMap[] newDocIdToOldOrdinals = new IntIntHashMap[numGraphs];
        int[][] oldToNewOrdinalMap = new int[numGraphs][];
        for (int i = 0; i < numGraphs; ++i) {
            KnnVectorValues.DocIndexIterator vectorsIter = null;
            switch (this.fieldInfo.getVectorEncoding()) {
                case BYTE: {
                    vectorsIter = this.graphReaders.get((int)i).reader.getByteVectorValues(this.fieldInfo.name).iterator();
                    break;
                }
                case FLOAT32: {
                    vectorsIter = this.graphReaders.get((int)i).reader.getFloatVectorValues(this.fieldInfo.name).iterator();
                }
            }
            newDocIdToOldOrdinals[i] = new IntIntHashMap(this.graphReaders.get((int)i).graphSize);
            MergeState.DocMap docMap = this.graphReaders.get(i).initDocMap();
            int docId = vectorsIter.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                int newDocId = docMap.get(docId);
                newDocIdToOldOrdinals[i].put(newDocId, vectorsIter.index());
                docId = vectorsIter.nextDoc();
            }
            oldToNewOrdinalMap[i] = new int[this.graphReaders.get((int)i).graphSize];
        }
        KnnVectorValues.DocIndexIterator mergedVectorIterator = mergedVectorValues.iterator();
        int docId = mergedVectorIterator.nextDoc();
        while (docId < Integer.MAX_VALUE) {
            int newOrd = mergedVectorIterator.index();
            for (int i = 0; i < numGraphs; ++i) {
                int oldOrd = newDocIdToOldOrdinals[i].getOrDefault(docId, -1);
                if (oldOrd == -1) continue;
                oldToNewOrdinalMap[i][oldOrd] = newOrd;
                if (initializedNodes == null) break;
                initializedNodes.set(newOrd);
                break;
            }
            docId = mergedVectorIterator.nextDoc();
        }
        return oldToNewOrdinalMap;
    }

    @Override
    public OnHeapHnswGraph merge(KnnVectorValues mergedVectorValues, InfoStream infoStream, int maxOrd) throws IOException {
        HnswBuilder builder = this.createBuilder(mergedVectorValues, maxOrd);
        builder.setInfoStream(infoStream);
        return builder.build(maxOrd);
    }

    private static boolean noDeletes(Bits liveDocs) {
        if (liveDocs == null) {
            return true;
        }
        for (int i = 0; i < liveDocs.length(); ++i) {
            if (liveDocs.get(i)) continue;
            return false;
        }
        return true;
    }

    protected record GraphReader(KnnVectorsReader reader, MergeState.DocMap initDocMap, int graphSize) {
    }
}

