/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui;

import com.yakindu.licmgmt.ui.internal.utils.EclipseLicenseHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public abstract class AbstractLicenseFeature {
    protected static final String DEFAULT_FEATURE_URL = "http://www.yakindu.com";
    protected static final String DEFAULT_FAQ_URL = "https://www.itemis.com/en/yakindu/licenses/faq";
    protected static final String DEFAULT_SUPPORT_URL = "mailto:licenses@yakindu.com?subject=%s&body=%s";
    protected static final String DEFAULT_BODY = "Please describe your problem here. It would also be helpful to attach the diagnosis report that can be created in the License Preferences.";

    public abstract String getProductName();

    public abstract String getFeatureName();

    public abstract String getLicenseFeatureId();

    public abstract String getMinimalRequiredLicenseVersion();

    public String getFeatureUrl() {
        return DEFAULT_FEATURE_URL;
    }

    public String getFaqUrl() {
        return DEFAULT_FAQ_URL;
    }

    public String getSupportUrl() {
        String featureAndProductName = EclipseLicenseHelper.INSTANCE.getFeatureAndProductName(this);
        try {
            String subject = URLEncoder.encode(String.valueOf(featureAndProductName) + " license issues", "UTF-8");
            String body = URLEncoder.encode(DEFAULT_BODY, "UTF-8");
            return String.format(DEFAULT_SUPPORT_URL, subject, body).replace("+", " ");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return String.format(DEFAULT_SUPPORT_URL, this.getLicenseFeatureId(), DEFAULT_BODY).replace("+", " ");
        }
    }
}

