/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.dialogs;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class BorrowingDialog
extends MessageDialog {
    private static final String[] MSG_DIALOG_BUTTON_LABELS = new String[]{"OK", "Cancel"};
    private final int minBorrowHours = 1;
    private int maxBorrowHours = 1;
    private int selectedBorrowHours;
    private Label statusLabel;
    private Composite container;

    public BorrowingDialog(Shell parentShell, int maxBorrowHours) {
        super(parentShell, "Borrow Floating License", null, "", 6, MSG_DIALOG_BUTTON_LABELS, 0);
        this.maxBorrowHours = maxBorrowHours;
        this.message = this.createDialogMessage();
    }

    private String createDialogMessage() {
        String msg = "Please select the number of hours you want to borrow this license.\n";
        if (this.maxBorrowHours >= 24) {
            int maxBorrowDays = this.maxBorrowHours / 24;
            String dayString = maxBorrowDays == 1 ? "day" : "days";
            int restHours = this.maxBorrowHours % 24;
            if (restHours != 0) {
                String hourString = restHours == 1 ? "hour" : "hours";
                msg = String.valueOf(msg) + "The maximal borrowing time is " + this.maxBorrowHours + " hours (= " + maxBorrowDays + " " + dayString + " " + restHours + " " + hourString + ").";
            } else {
                msg = String.valueOf(msg) + "The maximal borrowing time is " + this.maxBorrowHours + " hours (= " + maxBorrowDays + " " + dayString + ").";
            }
        } else {
            msg = String.valueOf(msg) + "The maximal borrowing time is " + this.maxBorrowHours + " hours.";
        }
        return msg;
    }

    protected Control createMessageArea(Composite parent) {
        Composite messageContainer = (Composite)super.createMessageArea(parent);
        new Label(messageContainer, 0);
        this.container = new Composite(messageContainer, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)new GridData(256, 2, true, true));
        Label hourSpinnerLabel = new Label(this.container, 0);
        hourSpinnerLabel.setText("Hours:");
        final Spinner hourSpinner = new Spinner(this.container, 0);
        hourSpinner.setIncrement(1);
        hourSpinner.setMinimum(1);
        hourSpinner.setMaximum(this.maxBorrowHours);
        hourSpinner.setSelection(this.maxBorrowHours);
        hourSpinner.setLayoutData((Object)new GridData(70, -1));
        this.selectedBorrowHours = hourSpinner.getSelection();
        Label datePickerLabel = new Label(this.container, 0);
        datePickerLabel.setText("End date:");
        final DateTime datePicker = new DateTime(this.container, 2084);
        Calendar maxBorrowDate = this.getMaxBorrowDate();
        int year = maxBorrowDate.get(1);
        int month = maxBorrowDate.get(2);
        int day = maxBorrowDate.get(5);
        datePicker.setDate(year, month, day);
        this.statusLabel = new Label(this.container, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.statusLabel.setLayoutData((Object)gridData);
        this.statusLabel.setText(this.getStatusMsg());
        hourSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BorrowingDialog.this.selectedBorrowHours = hourSpinner.getSelection();
            }
        });
        hourSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int newValue = -1;
                try {
                    newValue = Integer.parseInt(hourSpinner.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.isValidInput(newValue)) {
                    BorrowingDialog.this.selectedBorrowHours = newValue;
                    BorrowingDialog.this.displayStatusMsg();
                    this.updateDatePicker();
                } else {
                    BorrowingDialog.this.displayErrorMsg(BorrowingDialog.this.getErrorMsgHour());
                }
            }

            private boolean isValidInput(int newValue) {
                return newValue >= 1 && newValue <= BorrowingDialog.this.maxBorrowHours;
            }

            private void updateDatePicker() {
                Calendar cal = Calendar.getInstance();
                cal.add(11, BorrowingDialog.this.selectedBorrowHours);
                datePicker.setDate(cal.get(1), cal.get(2), cal.get(5));
            }
        });
        datePicker.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Calendar selected = this.getSelectedDate(datePicker);
                if (this.isValidInput(selected)) {
                    BorrowingDialog.this.displayStatusMsg();
                    this.updateHours();
                } else {
                    BorrowingDialog.this.displayErrorMsg(BorrowingDialog.this.getErrorMsgDate());
                }
            }

            private boolean isValidInput(Calendar selected) {
                Calendar upperBound = Calendar.getInstance();
                upperBound.add(5, BorrowingDialog.this.maxBorrowHours / 24 + 1);
                return selected.after(BorrowingDialog.this.getCurrentDate()) && selected.before(upperBound);
            }

            private void updateHours() {
                long now = Calendar.getInstance().getTimeInMillis();
                Calendar cal = this.getSelectedDate(datePicker);
                long selected = cal.getTimeInMillis();
                long diffDays = (selected - now) / 86400000L;
                hourSpinner.setSelection(Integer.parseInt(String.valueOf(diffDays)) * 24);
            }

            protected Calendar getSelectedDate(DateTime datePicker2) {
                Calendar cal = Calendar.getInstance();
                cal.set(datePicker2.getYear(), datePicker2.getMonth(), datePicker2.getDay());
                return cal;
            }
        });
        return parent;
    }

    public int getSelectedBorrowHours() {
        return this.selectedBorrowHours;
    }

    private Calendar getCurrentDate() {
        return Calendar.getInstance();
    }

    private Calendar getMaxBorrowDate() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, this.maxBorrowHours / 24);
        return cal;
    }

    private String getErrorMsgHour() {
        return "Please insert a number between 1 and " + this.maxBorrowHours + ".";
    }

    private String getErrorMsgDate() {
        String nowAsString = SimpleDateFormat.getInstance().format(this.getCurrentDate().getTime());
        String maxAsString = SimpleDateFormat.getInstance().format(this.getMaxBorrowDate().getTime());
        return "Please insert a date between " + nowAsString + " and " + maxAsString + ".";
    }

    private void displayErrorMsg(String message) {
        this.statusLabel.setText(message);
        this.statusLabel.pack(true);
        this.container.pack();
        this.getButton(0).setEnabled(false);
        this.statusLabel.setForeground(this.container.getDisplay().getSystemColor(3));
    }

    private void displayStatusMsg() {
        this.statusLabel.setText(this.getStatusMsg());
        this.statusLabel.pack(true);
        this.container.pack();
        this.getButton(0).setEnabled(true);
        this.statusLabel.setForeground(this.container.getDisplay().getSystemColor(2));
    }

    private String getStatusMsg() {
        Calendar borrowExpireDate = Calendar.getInstance();
        borrowExpireDate.add(11, this.selectedBorrowHours);
        String borrowExpireDateAsString = SimpleDateFormat.getInstance().format(borrowExpireDate.getTime());
        return "License will be borrowed until " + borrowExpireDateAsString;
    }
}

