/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.dialogs;

import com.yakindu.licmgmt.internal.utils.EclipsePathUtils;
import com.yakindu.licmgmt.internal.utils.PathUtils;
import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportLicenseDialog
extends Dialog {
    private static final String USER_HOME_PATH = "User home path: " + PathUtils.getUserHomePath();
    private static final String APPLICATION_PATH = "Application path: " + EclipsePathUtils.getEclipsePath();
    private static final String[] MSG_DIALOG_BUTTON_LABELS = new String[]{"OK", "Cancel"};
    private static final String MSG_DIALOG_OVERWRITE_MESSAGE = "File \"%s\" already exists in target folder.%n%nOverwrite?";
    private static final String MSG_DIALOG_ALREADY_LOADED = "File \"%s\" is already located in target folder.";
    private Combo comboTargetPath;
    private Text textLicensePath;
    private String licensePath = "";
    private String targetPath = "";

    public ImportLicenseDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.validatePaths();
        return control;
    }

    protected Control createDialogArea(final Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        Label labelLicensePath = new Label(composite, 0);
        labelLicensePath.setText("License file:");
        labelLicensePath.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.textLicensePath = new Text(composite, 2048);
        this.textLicensePath.setEditable(false);
        this.textLicensePath.setText("none selected");
        GridData layoutData = new GridData(4, 0x1000000, true, true, 1, 1);
        layoutData.minimumWidth = 500;
        this.textLicensePath.setLayoutData((Object)layoutData);
        Button importButton = new Button(composite, 8);
        importButton.setText("Select");
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(parent.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.*", "*.lic"});
                fileDialog.setFilterIndex(1);
                fileDialog.setText("Select license file");
                String open = fileDialog.open();
                if (open != null) {
                    ImportLicenseDialog.this.textLicensePath.setText(open);
                    ImportLicenseDialog.this.licensePath = open;
                }
                ImportLicenseDialog.this.validatePaths();
            }
        };
        Label labelTargetPath = new Label(composite, 0);
        labelTargetPath.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        labelTargetPath.setText("Target path:");
        this.comboTargetPath = new Combo(composite, 8);
        this.comboTargetPath.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.comboTargetPath.add(USER_HOME_PATH);
        String appPath = EclipsePathUtils.getEclipsePath();
        if (appPath != null) {
            this.comboTargetPath.add(APPLICATION_PATH);
        }
        this.comboTargetPath.select(0);
        this.targetPath = this.comboTargetPath.getItem(this.comboTargetPath.getSelectionIndex());
        this.comboTargetPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportLicenseDialog.this.targetPath = ImportLicenseDialog.this.comboTargetPath.getItem(ImportLicenseDialog.this.comboTargetPath.getSelectionIndex());
            }
        });
        importButton.addSelectionListener((SelectionListener)selectionListener);
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Import License");
    }

    public String getTargetPath() {
        if (this.targetPath.equals(APPLICATION_PATH)) {
            return EclipsePathUtils.getEclipsePath();
        }
        if (this.targetPath.equals(USER_HOME_PATH)) {
            return PathUtils.getUserHomePath();
        }
        return this.targetPath;
    }

    public String getLicensePath() {
        return this.licensePath;
    }

    protected void validatePaths() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(false);
            File file = new File(this.getLicensePath());
            if (file.exists()) {
                button.setEnabled(true);
            }
        }
    }

    protected void okPressed() {
        File file = new File(this.getLicensePath());
        File targetDir = new File(this.getTargetPath());
        if (file.getParent().equals(targetDir.getAbsolutePath())) {
            String msg = String.format(MSG_DIALOG_ALREADY_LOADED, file.getName());
            MessageDialog.openInformation((Shell)this.getShell(), (String)"File already loaded", (String)msg);
            return;
        }
        if (this.isFileExisting(file, targetDir)) {
            String msg = String.format(MSG_DIALOG_OVERWRITE_MESSAGE, file.getName());
            MessageDialog dialog = new MessageDialog(this.getShell(), "Confirm Overwrite", null, msg, 6, MSG_DIALOG_BUTTON_LABELS, 1);
            if (dialog.open() == 1) {
                return;
            }
        }
        super.okPressed();
    }

    protected boolean isFileExisting(File file, File targetDir) {
        if (file.isFile() && file.exists() && targetDir.isDirectory() && targetDir.exists()) {
            File[] fileArray = targetDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File targetFile = fileArray[n2];
                if (file.getName().equals(targetFile.getName())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

