/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.dialogs;

import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.ServerSettings;
import com.yakindu.licmgmt.internal.LicenseManager;
import com.yakindu.licmgmt.ui.internal.dialogs.actions.AbstractInvalidLicenseAction;
import com.yakindu.licmgmt.ui.internal.dialogs.actions.BuyLicenseAction;
import com.yakindu.licmgmt.ui.internal.dialogs.actions.ContactSupportLicenseAction;
import com.yakindu.licmgmt.ui.internal.dialogs.actions.DisableLicenseAction;
import com.yakindu.licmgmt.ui.internal.dialogs.actions.EnableLicenseAction;
import com.yakindu.licmgmt.ui.internal.dialogs.actions.ImportLicenseAction;
import com.yakindu.licmgmt.ui.internal.dialogs.actions.LinkFaqLicenseAction;
import com.yakindu.licmgmt.ui.internal.dialogs.actions.PluginDongleLicenseAction;
import com.yakindu.licmgmt.ui.internal.dialogs.actions.RetryLicenseAction;
import com.yakindu.licmgmt.ui.internal.dialogs.actions.SetLicenseServerAction;
import com.yakindu.licmgmt.ui.internal.utils.EclipseLicenseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class InvalidLicenseActionHandler {
    public Collection<AbstractInvalidLicenseAction> getInvalidLicenseActions(LicenseManager licenseManager) {
        ArrayList<AbstractInvalidLicenseAction> actions = new ArrayList<AbstractInvalidLicenseAction>();
        String featureId = licenseManager.getFeatureId();
        switch (licenseManager.getLmxStatus()) {
            case LMX_NO_NETWORK: 
            case LMX_NETWORK_ERROR: 
            case LMX_NO_NETWORK_HOST: {
                actions.add(new LinkFaqLicenseAction(featureId));
                actions.add(new RetryLicenseAction(licenseManager));
                actions.add(new ImportLicenseAction());
                actions.add(new ContactSupportLicenseAction(featureId));
                actions.add(new DisableLicenseAction(featureId));
                actions.add(new BuyLicenseAction(featureId));
                break;
            }
            case LMX_HEARTBEAT_LOST_LICENSE: {
                actions.add(new RetryLicenseAction(licenseManager));
                actions.add(new LinkFaqLicenseAction(featureId));
                actions.add(new DisableLicenseAction(featureId));
                break;
            }
            case LMX_FEATURE_NOT_FOUND: {
                actions.add(new BuyLicenseAction(featureId));
                actions.add(new ImportLicenseAction());
                if (this.isLicenseServerSet()) {
                    actions.add(new RetryLicenseAction(licenseManager));
                } else {
                    actions.add(new SetLicenseServerAction());
                }
                actions.add(new LinkFaqLicenseAction(featureId));
                actions.add(new DisableLicenseAction(featureId));
                break;
            }
            case LMX_BAD_HOSTID: {
                if (licenseManager.isDongleLicense()) {
                    actions.add(new PluginDongleLicenseAction(licenseManager));
                }
                actions.add(new BuyLicenseAction(featureId));
                actions.add(new ImportLicenseAction());
                actions.add(new LinkFaqLicenseAction(featureId));
                actions.add(new ContactSupportLicenseAction(featureId));
                actions.add(new DisableLicenseAction(featureId));
                break;
            }
            case LMX_TOO_LATE_DATE: {
                actions.add(new BuyLicenseAction(featureId));
                actions.add(new ImportLicenseAction());
                if (!this.isLicenseServerSet()) {
                    actions.add(new SetLicenseServerAction());
                }
                actions.add(new ContactSupportLicenseAction(featureId));
                actions.add(new DisableLicenseAction(featureId));
                break;
            }
            case LMX_BAD_VERSION: {
                actions.add(new BuyLicenseAction(featureId, true));
                actions.add(new ImportLicenseAction());
                actions.add(new LinkFaqLicenseAction(featureId));
                actions.add(new DisableLicenseAction(featureId));
                break;
            }
            case LMX_NOT_ENOUGH_LICENSES: {
                actions.add(new BuyLicenseAction(featureId));
                actions.add(new RetryLicenseAction(licenseManager));
                actions.add(new ImportLicenseAction());
                actions.add(new DisableLicenseAction(featureId));
                break;
            }
            case LMX_DONGLE_ERROR: {
                actions.add(new PluginDongleLicenseAction(licenseManager));
                actions.add(new LinkFaqLicenseAction(featureId));
                actions.add(new ContactSupportLicenseAction(featureId));
                actions.add(new ImportLicenseAction());
                actions.add(new BuyLicenseAction(featureId));
                actions.add(new DisableLicenseAction(featureId));
                break;
            }
            case LMX_VENDOR_DENY: {
                actions.add(new EnableLicenseAction(featureId));
                break;
            }
            default: {
                actions.add(new LinkFaqLicenseAction(featureId));
                actions.add(new ImportLicenseAction());
                if (!this.isLicenseServerSet()) {
                    actions.add(new SetLicenseServerAction());
                }
                actions.add(new BuyLicenseAction(featureId));
                actions.add(new ContactSupportLicenseAction(featureId));
                actions.add(new DisableLicenseAction(featureId));
            }
        }
        return Collections.unmodifiableList(actions);
    }

    public static String getErrorMessage(LicenseManager licenseManager) {
        switch (licenseManager.getLmxStatus()) {
            case LMX_NO_NETWORK: 
            case LMX_NETWORK_ERROR: 
            case LMX_NO_NETWORK_HOST: {
                return "Unable to connect to the license server";
            }
            case LMX_HEARTBEAT_LOST_LICENSE: {
                return "Connection to the license server is lost";
            }
            case LMX_FEATURE_NOT_FOUND: {
                return "No license could be found";
            }
            case LMX_BAD_HOSTID: {
                return "HostID does not match license";
            }
            case LMX_TOO_LATE_DATE: {
                return "The software product is expired";
            }
            case LMX_BAD_VERSION: {
                return "The license " + EclipseLicenseHelper.INSTANCE.getHighestLicenseVersion(licenseManager.getFeatureId(), licenseManager.getLicenseInfos()) + " is not valid any more for the currently installed version " + licenseManager.getFeatureVersion();
            }
            case LMX_NOT_ENOUGH_LICENSES: {
                return "All licenses of the product are checked out at the moment";
            }
            case LMX_DONGLE_ERROR: {
                return "Dongle is not attached or does not function correctly";
            }
            case LMX_VENDOR_DENY: {
                return "The license is currently disabled";
            }
        }
        return "The product is not available.";
    }

    private boolean isLicenseServerSet() {
        ServerSettings serverSettings = ILicenseService.INSTANCE.getServerSettings();
        return serverSettings.isEnabled() || serverSettings.equals((Object)ServerSettings.NOT_AVAILABLE);
    }
}

