/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.preferences;

import com.xformation.lmx.LmxFeatureInfo;
import com.xformation.lmx.LmxStatus;
import com.yakindu.licmgmt.IEclipseLicenseManager;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.LicenseException;
import com.yakindu.licmgmt.ui.AbstractLicenseFeature;
import com.yakindu.licmgmt.ui.internal.LicenseManagementUiActivator;
import com.yakindu.licmgmt.ui.internal.dialogs.BorrowingDialog;
import com.yakindu.licmgmt.ui.internal.dialogs.DeleteDialog;
import com.yakindu.licmgmt.ui.internal.model.LicenseTableModel;
import com.yakindu.licmgmt.ui.internal.model.TableItemData;
import com.yakindu.licmgmt.ui.internal.utils.EclipseLicenseHelper;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ActionButtonSelectionListener
extends SelectionAdapter {
    private final String[] MSG_DIALOG_BUTTON_LABELS = new String[]{"OK", "Cancel"};
    private final TableItemData item;

    public ActionButtonSelectionListener(TableItemData item) {
        this.item = item;
    }

    public void widgetSelected(SelectionEvent e) {
        this.openDialogBox(this.item, (Control)e.getSource());
    }

    private void openDialogBox(TableItemData element, Control parent) {
        LmxFeatureInfo featureInfo = element.getFeatureInfo();
        AbstractLicenseFeature licenseFeature = element.getLicenseFeature();
        switch (element.getActionType()) {
            case DELETABLE: {
                DeleteDialog dialog = this.createDeleteDialog(parent, featureInfo);
                if (dialog == null || dialog.open() != 0) break;
                this.deleteLicense(featureInfo, dialog.getRelatedLicenseManagers());
                this.updateModel(parent);
                break;
            }
            case BORROWABLE: {
                BorrowingDialog borrowDialog = this.createBorrowDialog(parent, featureInfo);
                if (borrowDialog == null || borrowDialog.open() != 0) break;
                this.borrowLicense(licenseFeature, borrowDialog.getSelectedBorrowHours(), parent);
                this.updateModel(parent);
                break;
            }
            case RETURNABLE: {
                MessageDialog returnDialog = this.createReturnDialog(parent);
                if (returnDialog.open() != 0) break;
                this.returnLicense(licenseFeature, parent);
                this.updateModel(parent);
                break;
            }
            case ACQUIREABLE: 
            case RETRYABLE: {
                this.acquireLicense((ILicenseManager)element.getLicenseManager(), licenseFeature, parent);
                this.updateModel(parent);
                break;
            }
            case RELEASABLE: {
                this.releaseLicense(element.getLicenseManager(), licenseFeature, parent);
                this.updateModel(parent);
            }
        }
    }

    private void updateModel(Control parent) {
        if (!parent.isDisposed()) {
            LicenseTableModel.getInstance().updateModel(parent.getShell());
        }
    }

    private void releaseLicense(IEclipseLicenseManager licenseManager, AbstractLicenseFeature licenseFeature, Control parent) {
        IRunnableWithProgress op = monitor -> {
            monitor.beginTask("Releasing license" + EclipseLicenseHelper.INSTANCE.getFeatureAndProductName(licenseFeature) + "...", -1);
            LmxStatus releaseStatus = licenseManager.release();
            if (!LmxStatus.LMX_SUCCESS.equals((Object)releaseStatus)) {
                String msg = "An error occured when trying to release the selected license.";
                LicenseManagementUiActivator.logErrorMessage("An error occured when trying to release the selected license.");
                Status status = new Status(4, "com.yakindu.licmgmt.ui", licenseManager.getStatusMessage());
                ErrorDialog.openError((Shell)parent.getShell(), (String)"Error during release process", (String)"An error occured when trying to release the selected license.", (IStatus)status);
            }
            monitor.done();
        };
        try {
            new ProgressMonitorDialog(parent.getShell()).run(true, false, op);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void acquireLicense(ILicenseManager licenseManager, AbstractLicenseFeature licenseFeature, Control parent) {
        IRunnableWithProgress op = monitor -> {
            monitor.beginTask("Acquiring license " + EclipseLicenseHelper.INSTANCE.getFeatureAndProductName(licenseFeature) + "...", -1);
            if (!LmxStatus.LMX_SUCCESS.equals((Object)licenseManager.acquire())) {
                String msg = "An error occured when trying to acquire the selected license.";
                LicenseManagementUiActivator.logErrorMessage("An error occured when trying to acquire the selected license.");
            }
            monitor.done();
        };
        try {
            new ProgressMonitorDialog(parent.getShell()).run(true, false, op);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private BorrowingDialog createBorrowDialog(Control parent, LmxFeatureInfo featureInfo) {
        return new BorrowingDialog(parent.getShell(), featureInfo.getActualBorrowHours());
    }

    private void borrowLicense(AbstractLicenseFeature licenseFeature, int hours, Control parent) {
        IRunnableWithProgress op = monitor -> {
            monitor.beginTask("Borrowing license " + EclipseLicenseHelper.INSTANCE.getFeatureAndProductName(licenseFeature) + "...", -1);
            try {
                IEclipseLicenseManager manager = EclipseLicenseHelper.INSTANCE.getLicenseManager(licenseFeature);
                LmxStatus lmxStatus = manager.borrow(hours);
                this.handleLmxStatus(lmxStatus, (ILicenseManager)manager, parent);
            }
            catch (LicenseException e) {
                this.handleLmxException(parent, e.getMessage(), "Error during borrow process", "An error occured when trying to borrow the selected license.");
            }
            monitor.done();
        };
        try {
            new ProgressMonitorDialog(parent.getShell()).run(true, false, op);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void handleLmxException(Control parent, String errorMsg, String title, String detailedMsg) {
        LicenseManagementUiActivator.logErrorMessage(detailedMsg);
        Status status = new Status(4, "com.yakindu.licmgmt.ui", errorMsg);
        Display.getDefault().asyncExec(() -> ErrorDialog.openError((Shell)parent.getShell(), (String)title, (String)detailedMsg, (IStatus)status));
    }

    private void handleLmxStatus(LmxStatus lmxStatus, ILicenseManager manager, Control parent) {
        if (LmxStatus.LMX_SINGLE_LOCK == lmxStatus) {
            this.handleLmxException(parent, manager.getStatusMessage(), "Error during borrow process", "An error occurred while trying to borrow the selected license. A possible cause could be that no borrowable license is available.");
            manager.acquire();
        }
    }

    private MessageDialog createReturnDialog(Control parent) {
        return new MessageDialog(parent.getShell(), "Return License", null, "When you return a borrowed license you can not use this feature in offline mode.\nDo you really want to early return your license?", 6, this.MSG_DIALOG_BUTTON_LABELS, 0);
    }

    private void returnLicense(AbstractLicenseFeature licenseFeature, Control parent) {
        IRunnableWithProgress op = monitor -> {
            monitor.beginTask("Un-borrowing license " + EclipseLicenseHelper.INSTANCE.getFeatureAndProductName(licenseFeature) + "...", -1);
            try {
                IEclipseLicenseManager manager = EclipseLicenseHelper.INSTANCE.getLicenseManager(licenseFeature);
                manager.unborrow();
            }
            catch (LicenseException e) {
                String msg = "An error occured when trying to return the selected license.";
                LicenseManagementUiActivator.logErrorMessage("An error occured when trying to return the selected license.");
                Status status = new Status(4, "com.yakindu.licmgmt.ui", e.getMessage());
                ErrorDialog.openError((Shell)parent.getShell(), (String)"Error during return process", (String)"An error occured when trying to return the selected license.", (IStatus)status);
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(parent.getShell()).run(true, false, op);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private DeleteDialog createDeleteDialog(Control parent, LmxFeatureInfo featureInfo) {
        File file = this.getLicenseFile(featureInfo);
        if (this.isValid(file)) {
            return new DeleteDialog(parent.getShell(), file);
        }
        return null;
    }

    private void deleteLicense(LmxFeatureInfo featureInfo, Set<ILicenseManager> managers) {
        File file = this.getLicenseFile(featureInfo);
        if (this.isValid(file)) {
            this.releaseLicenses(managers);
            file.delete();
        } else {
            String error = String.format("Could not delete file \"%s\".", file.getName());
            LicenseManagementUiActivator.logErrorMessage(error);
        }
    }

    private File getLicenseFile(LmxFeatureInfo featureInfo) {
        return featureInfo == null ? null : new File(featureInfo.getPath());
    }

    private boolean isValid(File file) {
        return file != null && file.exists() && file.isFile();
    }

    private void releaseLicenses(Set<ILicenseManager> managers) {
        LicenseTableModel.getInstance().setListenerEnabled(false);
        try {
            for (ILicenseManager manager : managers) {
                if (LmxStatus.LMX_SUCCESS.equals((Object)manager.release())) continue;
                LicenseManagementUiActivator.logErrorMessage(manager.getStatusMessage());
            }
        }
        finally {
            LicenseTableModel.getInstance().setListenerEnabled(true);
        }
    }
}

