/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.preferences;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;

public abstract class ColumnBasedSelectionListener
implements ISelectionChangedListener {
    protected final TableViewer viewer;
    protected Point mouseLocation;
    protected final int columnIndex;

    public ColumnBasedSelectionListener(TableViewer viewer, int columnIndex) {
        this.viewer = viewer;
        this.columnIndex = columnIndex;
        this.registerMouseListener();
    }

    protected void registerMouseListener() {
        this.viewer.getControl().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                ColumnBasedSelectionListener.this.mouseLocation = new Point(e.x, e.y);
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ViewerCell cell;
        if (this.viewer != null && ((cell = this.viewer.getCell(this.mouseLocation)) == null || cell.getColumnIndex() != this.columnIndex)) {
            return;
        }
        this.doSelectionChanged(event);
    }

    protected abstract void doSelectionChanged(SelectionChangedEvent var1);
}

