/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.preferences;

import com.xformation.lmx.LmxFeatureInfo;
import com.yakindu.licmgmt.ui.AbstractLicenseFeature;
import com.yakindu.licmgmt.ui.internal.model.TableItemData;
import com.yakindu.licmgmt.ui.internal.preferences.ColumnBasedSelectionListener;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;

public class NotificationSelectionListener
extends ColumnBasedSelectionListener {
    private final Map<String, Boolean> toBeSavedNotificationSettings;

    public NotificationSelectionListener(TableViewer viewer, int columnIndex, Map<String, Boolean> toBeSavedNotificationSettings) {
        super(viewer, columnIndex);
        this.toBeSavedNotificationSettings = toBeSavedNotificationSettings;
    }

    @Override
    protected void doSelectionChanged(SelectionChangedEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (firstElement instanceof TableItemData) {
            TableItemData tableItemData = (TableItemData)firstElement;
            this.updateNotification(tableItemData);
        }
    }

    private void updateNotification(TableItemData element) {
        LmxFeatureInfo featureInfo = element.getFeatureInfo();
        AbstractLicenseFeature licenseFeature = element.getLicenseFeature();
        if (featureInfo != null && this.toBeSavedNotificationSettings.containsKey(featureInfo.getFeatureName())) {
            boolean value = this.toBeSavedNotificationSettings.get(featureInfo.getFeatureName());
            this.toBeSavedNotificationSettings.put(featureInfo.getFeatureName(), !value);
        } else if (licenseFeature != null && this.toBeSavedNotificationSettings.containsKey(licenseFeature.getLicenseFeatureId())) {
            boolean value = this.toBeSavedNotificationSettings.get(licenseFeature.getLicenseFeatureId());
            this.toBeSavedNotificationSettings.put(licenseFeature.getLicenseFeatureId(), !value);
        }
        this.viewer.refresh();
    }
}

