/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.preferences.providers;

import com.yakindu.licmgmt.LicenseStatus;
import com.yakindu.licmgmt.ui.internal.model.TableItemData;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class LicenseTableViewerLabelProvider
extends ColumnLabelProvider {
    private Map<String, Boolean> prefLicenseEnabled;
    private static final Map<LicenseStatus, Integer> STATUS_COLOR_MAP = new HashMap<LicenseStatus, Integer>(){
        {
            this.put(LicenseStatus.UNCHECKED, 16);
            this.put(LicenseStatus.UNUSED, 16);
            this.put(LicenseStatus.DEACTIVATED, 16);
            this.put(LicenseStatus.MISSING, 3);
            this.put(LicenseStatus.EXPIRED, 4);
        }
    };

    public LicenseTableViewerLabelProvider(Map<String, Boolean> licensesEnabled) {
        this.prefLicenseEnabled = licensesEnabled;
    }

    public Color getForeground(Object element) {
        TableItemData data = (TableItemData)element;
        Integer colorCode = this.getColorCode(data);
        if (colorCode == null) {
            return null;
        }
        return Display.getDefault().getSystemColor(colorCode.intValue());
    }

    private Integer getColorCode(TableItemData data) {
        LicenseStatus statusToColor = data.getStatus();
        String licenseId = data.getLicenseFeature().getLicenseFeatureId();
        Boolean value = this.prefLicenseEnabled.get(licenseId);
        if (!data.getLicenseManager().isCheckedOut() && value != null && !value.booleanValue()) {
            statusToColor = LicenseStatus.DEACTIVATED;
        }
        Integer colorCode = STATUS_COLOR_MAP.get(statusToColor);
        return colorCode;
    }
}

