/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.preferences.providers;

import com.yakindu.licmgmt.IEclipseLicenseManager;
import com.yakindu.licmgmt.LicenseException;
import com.yakindu.licmgmt.LicenseStatus;
import com.yakindu.licmgmt.internal.utils.DateUtils;
import com.yakindu.licmgmt.ui.AbstractLicenseFeature;
import com.yakindu.licmgmt.ui.internal.model.TableItemData;
import com.yakindu.licmgmt.ui.internal.preferences.providers.LicenseTableViewerLabelProvider;
import com.yakindu.licmgmt.ui.internal.utils.EclipseLicenseHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class StatusLabelProvider
extends LicenseTableViewerLabelProvider {
    public StatusLabelProvider(Map<String, Boolean> licensesEnabled) {
        super(licensesEnabled);
    }

    public String getToolTipText(Object element) {
        TableItemData data = (TableItemData)element;
        if (data.getStatus() == LicenseStatus.VALID && this.getExpirationsDays(data.getLicenseFeature()) > 0) {
            return "Expiration date: " + data.getFeatureInfo().getActualExpireTime();
        }
        if (data.getStatus() == LicenseStatus.BORROWED) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            String expireDate = data.getFeatureInfo().getActualExpireTime();
            Date expDate = DateUtils.convertActualExpireTime((String)expireDate);
            return "Borrow expiration date: " + dateFormat.format(expDate);
        }
        return data.getLicenseManager().getStatusMessage();
    }

    public String getText(Object element) {
        TableItemData data = (TableItemData)element;
        String statusText = "";
        if (data.getStatus() == LicenseStatus.VALID && this.getExpirationsDays(data.getLicenseFeature()) > 0) {
            statusText = this.statusMsgWithExpirationDays("Expires in ", this.getExpirationsDays(data.getLicenseFeature()));
        } else if (data.getStatus() == LicenseStatus.BORROWED) {
            Date expDate = DateUtils.convertActualExpireTime((String)data.getFeatureInfo().getActualExpireTime());
            long timeDiff = expDate.getTime() - Calendar.getInstance().getTime().getTime();
            statusText = "Borrowed for " + DateUtils.getDaysHoursText((long)timeDiff);
        } else {
            statusText = data.getStatus().text;
        }
        return statusText;
    }

    private int getExpirationsDays(AbstractLicenseFeature feature) {
        try {
            IEclipseLicenseManager licenseManager = EclipseLicenseHelper.INSTANCE.getLicenseManager(feature);
            int hours = licenseManager.getExpireTime();
            return (hours + 23) / 24;
        }
        catch (LicenseException e) {
            return -3;
        }
    }

    private String statusMsgWithExpirationDays(String prefix, int expirationDays) {
        String days = expirationDays == 1 ? "day" : "days";
        return String.valueOf(prefix) + " " + expirationDays + " " + days;
    }
}

