/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.utils;

import com.xformation.lmx.LmxFeatureInfo;
import com.xformation.lmx.LmxLicenseInfo;
import com.xformation.lmx.LmxLicenseType;
import com.yakindu.licmgmt.IEclipseLicenseManager;
import com.yakindu.licmgmt.IEclipseLicenseService;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.LicenseException;
import com.yakindu.licmgmt.internal.EclipseLicenseManager;
import com.yakindu.licmgmt.internal.LicenseManager;
import com.yakindu.licmgmt.internal.LicenseVersion;
import com.yakindu.licmgmt.internal.LoggingHelper;
import com.yakindu.licmgmt.ui.AbstractLicenseFeature;
import com.yakindu.licmgmt.ui.internal.LicenseManagementUiActivator;
import com.yakindu.licmgmt.ui.internal.model.LicenseTableModel;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EclipseLicenseHelper {
    public static final EclipseLicenseHelper INSTANCE = new EclipseLicenseHelper();

    public IEclipseLicenseManager getLicenseManager(AbstractLicenseFeature feature) throws LicenseException {
        String featureId = feature.getLicenseFeatureId();
        String featureVer = feature.getMinimalRequiredLicenseVersion();
        return this.getEclipseLicenseService().getLicenseManager(featureId, featureVer);
    }

    protected IEclipseLicenseService getEclipseLicenseService() {
        return IEclipseLicenseService.INSTANCE;
    }

    public IEclipseLicenseManager getLoadedLicenseManager(String featureId) {
        return this.getEclipseLicenseService().getAllLicenseManagers().stream().filter(m -> m.getFeatureId().equals(featureId)).findFirst().orElse(null);
    }

    public AbstractLicenseFeature getLicenseFeature(String featureId) {
        if (featureId == null || featureId.isEmpty()) {
            return null;
        }
        return this.getLicenseFeatures().stream().filter(f -> f.getLicenseFeatureId().equals(featureId)).findFirst().orElse(null);
    }

    protected List<AbstractLicenseFeature> getLicenseFeatures() {
        return LicenseManagementUiActivator.getDefault().getLicenseFeatures();
    }

    public String getFeatureAndProductName(String featureId) {
        AbstractLicenseFeature licenseFeature = this.getLicenseFeature(featureId);
        return licenseFeature == null ? featureId : this.getFeatureAndProductName(licenseFeature);
    }

    public String getFeatureUrl(String featureId) {
        AbstractLicenseFeature licenseFeature = this.getLicenseFeature(featureId);
        return licenseFeature == null ? null : licenseFeature.getFeatureUrl();
    }

    public String getFaqUrl(String featureId) {
        AbstractLicenseFeature licenseFeature = this.getLicenseFeature(featureId);
        return licenseFeature == null ? null : licenseFeature.getFaqUrl();
    }

    public String getSupportUrl(String featureId) {
        AbstractLicenseFeature licenseFeature = this.getLicenseFeature(featureId);
        return licenseFeature == null ? null : licenseFeature.getSupportUrl();
    }

    public String getFeatureAndProductName(AbstractLicenseFeature licenseFeature) {
        if (licenseFeature == null) {
            return null;
        }
        String productName = licenseFeature.getProductName();
        String featureName = licenseFeature.getFeatureName();
        if (featureName == null || featureName.isEmpty() || productName == null || productName.isEmpty()) {
            throw new IllegalStateException("product and feature names must not be null or empty: " + licenseFeature.getLicenseFeatureId());
        }
        return String.valueOf(this.ensureItemisProductName(productName)) + " " + featureName;
    }

    public String ensureItemisProductName(String productName) {
        return productName.startsWith("itemis") ? productName : "itemis " + productName;
    }

    public void acquireImportedLicenses(final Shell shell, final String licenseFile) {
        final List<AbstractLicenseFeature> licenseFeatures = this.getLicenseFeatures();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Try to acquire licenses from imported file", licenseFeatures.size());
                if (shell != null) {
                    LicenseTableModel.getInstance().setListenerEnabled(false);
                }
                try {
                    for (AbstractLicenseFeature licenseFeature : licenseFeatures) {
                        try {
                            IEclipseLicenseManager licenseManager = EclipseLicenseHelper.this.getLicenseManager(licenseFeature);
                            if (EclipseLicenseHelper.this.isLicenseUpdateable(licenseFile, licenseManager)) {
                                monitor.subTask("Updating license feature '" + licenseManager.getFeatureId() + "'");
                                ((EclipseLicenseManager)licenseManager).updateLicense(true);
                            }
                            if (monitor.isCanceled()) {
                                LoggingHelper.warn((String)"Acquiring of imported license file with feature %s (%s) and version %s was canceled by the user!", (Object[])new Object[]{licenseFeature.getFeatureName(), licenseFeature.getLicenseFeatureId(), licenseFeature.getMinimalRequiredLicenseVersion()});
                                throw new InterruptedException();
                            }
                        }
                        catch (LicenseException e) {
                            LoggingHelper.info((String)"Unable to checkout a license for feature %s (%s) with version %s!", (Object[])new Object[]{licenseFeature.getFeatureName(), licenseFeature.getLicenseFeatureId(), licenseFeature.getMinimalRequiredLicenseVersion()});
                        }
                        monitor.worked(1);
                    }
                }
                catch (Throwable throwable) {
                    if (shell != null) {
                        LicenseTableModel.getInstance().setListenerEnabled(true);
                        Display.getDefault().syncExec(() -> LicenseTableModel.getInstance().updateModel(shell));
                    }
                    throw throwable;
                }
                if (shell != null) {
                    LicenseTableModel.getInstance().setListenerEnabled(true);
                    Display.getDefault().syncExec(() -> LicenseTableModel.getInstance().updateModel(shell));
                }
            }
        };
        try {
            this.run(shell, op);
        }
        catch (InvocationTargetException e) {
            LicenseManagementUiActivator.log("Failed to acquire licenses", 4, e, false, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void run(Shell shell, IRunnableWithProgress op) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(shell).run(true, true, op);
    }

    protected boolean isLicenseUpdateable(String licenseFile, IEclipseLicenseManager licenseManager) throws LicenseException {
        if (licenseManager.isEnabled()) {
            if (!licenseManager.isCheckedOut() && ((EclipseLicenseManager)licenseManager).isAcquireRequested()) {
                return true;
            }
            List licenseInfos = licenseManager.getLicenseInfos();
            for (LmxLicenseInfo licenseInfo : licenseInfos) {
                if (licenseInfo.getLicenseType() != LmxLicenseType.LMX_TYPE_LOCAL || !this.isAnyFeatureUpdateable(licenseManager, licenseInfo.getFeatures(), licenseFile)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAnyFeatureUpdateable(IEclipseLicenseManager licenseManager, List<LmxFeatureInfo> features, String licenseFile) throws LicenseException {
        for (LmxFeatureInfo featureInfo : features) {
            if (!licenseManager.getFeatureId().equals(featureInfo.getFeatureName())) continue;
            LmxFeatureInfo lmFeatureInfo = licenseManager.getFeatureInfo();
            if (lmFeatureInfo == null) {
                return true;
            }
            if (lmFeatureInfo.getLicenseType() != LmxLicenseType.LMX_TYPE_TRIAL && !lmFeatureInfo.getPath().equals(licenseFile)) continue;
            LmxLicenseType currentUsedFeatureInfoType = lmFeatureInfo.getLicenseType();
            LmxLicenseType potentiallyUsableFeatureInfoType = featureInfo.getLicenseType();
            if (potentiallyUsableFeatureInfoType.getValue() > currentUsedFeatureInfoType.getValue()) continue;
            return true;
        }
        return false;
    }

    public LicenseVersion getHighestLicenseVersion(String featureId, Collection<LmxLicenseInfo> licenseInfos) {
        LicenseVersion highestLicenseVersion = null;
        for (LmxLicenseInfo licenseInfo : licenseInfos) {
            for (LmxFeatureInfo featureInfo : licenseInfo.getFeatures()) {
                if (!featureInfo.getFeatureName().equals(featureId) || !this.isRegularLicense(featureInfo)) continue;
                LicenseVersion licenseVersion = new LicenseVersion(featureInfo.getMajorVer(), featureInfo.getMinorVer());
                if (highestLicenseVersion != null && licenseVersion.compareTo(highestLicenseVersion) < 1) continue;
                highestLicenseVersion = licenseVersion;
            }
        }
        return highestLicenseVersion;
    }

    public LicenseManager getLicenseManager(ILicenseManager licenseManager) {
        return (LicenseManager)((EclipseLicenseManager)licenseManager).getLicenseManager();
    }

    protected boolean isRegularLicense(LmxFeatureInfo featureInfo) {
        if (featureInfo == null) {
            return false;
        }
        switch (featureInfo.getLicenseType()) {
            case LMX_TYPE_LOCAL: 
            case LMX_TYPE_NETWORK: 
            case LMX_TYPE_BORROW: 
            case LMX_TYPE_GRACE: {
                return true;
            }
            case LMX_TYPE_TRIAL: {
                return false;
            }
        }
        throw new UnsupportedOperationException("Invalid license type: " + featureInfo.getLicenseType());
    }
}

