/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.cpp.files;

import com.google.inject.Inject;
import com.itemis.create.base.generator.core.types.Literals;
import com.yakindu.sct.generator.c.extensions.GenmodelEntries;
import com.yakindu.sct.generator.core.artifacts.IContentTemplate;
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations;
import com.yakindu.sct.generator.cpp.CppFileNaming;
import com.yakindu.sct.generator.cpp.CppNaming;
import com.yakindu.sct.generator.cpp.CppPointers;
import com.yakindu.sct.generator.cpp.CppSpecifiers;
import com.yakindu.sct.generator.cpp.types.CppTypes;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class TimerServiceSource
implements IContentTemplate<ExecutionFlow> {
    @Inject
    @Extension
    protected GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    protected CppFileNaming _cppFileNaming;
    @Inject
    @Extension
    protected CppNaming _cppNaming;
    @Inject
    @Extension
    protected CppTypes _cppTypes;
    @Inject
    @Extension
    protected Literals _literals;
    @Inject
    @Extension
    protected CppPointers _cppPointers;
    @Inject
    @Extension
    protected CppSpecifiers _cppSpecifiers;

    public String content(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) {
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._genmodelEntries.getLicenseText(entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _h = this._cppFileNaming.h(this._cppFileNaming.timerServiceModule());
        _builder.append(_h);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include <algorithm>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("using namespace sc::timer;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _setGenericTimer = this.setGenericTimer();
        _builder.append((Object)_setGenericTimer);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _unsetGenericTimer = this.unsetGenericTimer();
        _builder.append((Object)_unsetGenericTimer);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _setTimer = this.setTimer();
        _builder.append((Object)_setTimer);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _unsetTimer = this.unsetTimer();
        _builder.append((Object)_unsetTimer);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _setRuncycleTimerFor = this.setRuncycleTimerFor();
        _builder.append((Object)_setRuncycleTimerFor);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _unsetRuncycleTimerFor = this.unsetRuncycleTimerFor();
        _builder.append((Object)_unsetRuncycleTimerFor);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _proceed = this.proceed(entry);
        _builder.append((Object)_proceed);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _cancel = this.cancel();
        _builder.append((Object)_cancel);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _timeTillNextTask = this.timeTillNextTask();
        _builder.append((Object)_timeTillNextTask);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder.toString();
    }

    protected CharSequence cancel() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*! Cancel timer service. Use this to end possible timing threads.");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.append("void ");
        String _timerServiceImplementation = this._cppNaming.timerServiceImplementation();
        _builder.append(_timerServiceImplementation);
        _builder.append("::cancel() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("for (size_t idx = 0; idx < length; ++idx) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tasks[idx].reset();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tasks[idx].next_task_idx = idx + 1;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("next_active_task = length;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("next_free_task = 0;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence proceed(GeneratorEntry entry) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*!");
        _builder.newLine();
        _builder.append("* This function must be called by the user. The elapsed time must be calculated every time,");
        _builder.newLine();
        _builder.append("* the function gets called.");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.append("void ");
        String _timerServiceImplementation = this._cppNaming.timerServiceImplementation();
        _builder.append(_timerServiceImplementation);
        _builder.append("::proceed(");
        String _fqName = this._cppTypes.sc_time().fqName();
        _builder.append(_fqName);
        _builder.append(" elapsed_ms) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (next_active_task >= length) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        String _fqName_1 = this._cppTypes.sc_time().fqName();
        _builder.append(_fqName_1, "\t");
        _builder.append(" time_to_proceed = std::min(time_till_next_task(), elapsed_ms);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _fqName_2 = this._cppTypes.sc_time().fqName();
        _builder.append(_fqName_2, "\t");
        _builder.append(" proceeded_time = 0;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("while (time_to_proceed > 0) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* go through all active timers and update their time */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("size_t idx = next_active_task;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("while (idx < length) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("TimerTask &current_task = this->tasks[idx]; ");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("current_task.updateElapsedTimeMs(time_to_proceed);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("idx = current_task.next_task_idx;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        String _fqName_3 = this._cppTypes.sc_bool().fqName();
        _builder.append(_fqName_3, "\t\t");
        _builder.append(" task_fired;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("do {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("task_fired = false;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("size_t before_best = length;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("size_t best = next_active_task;");
        _builder.newLine();
        _builder.append("\t\t\t");
        String _fqName_4 = this._cppTypes.sc_time().fqName();
        _builder.append(_fqName_4, "\t\t\t");
        _builder.append(" best_remaining_time = tasks[best].data.get.time_ms - tasks[best].elapsed_time_ms;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("size_t last_task = best;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("size_t next_task = tasks[best].next_task_idx;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("while (next_task < length) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("TimerTask &current_task = tasks[next_task];");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        String _fqName_5 = this._cppTypes.sc_time().fqName();
        _builder.append(_fqName_5, "\t\t\t\t");
        _builder.append(" remaining_time = current_task.data.get.time_ms - current_task.elapsed_time_ms; ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("if (remaining_time < best_remaining_time || (remaining_time == best_remaining_time && !(tasks[best] < current_task))) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("best = next_task;");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("before_best = last_task;");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("best_remaining_time = remaining_time;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("last_task = next_task;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("next_task = current_task.next_task_idx;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (best_remaining_time <= 0) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        String _timerServiceImplementationTask = this._cppNaming.timerServiceImplementationTask();
        _builder.append(_timerServiceImplementationTask, "\t\t\t\t");
        _builder.append(" &best_task = tasks[best];");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        String _timerServiceImplementationTask_1 = this._cppNaming.timerServiceImplementationTask();
        _builder.append(_timerServiceImplementationTask_1, "\t\t\t\t");
        _builder.append("::TaskData data(best_task.data);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("if (best_task.isPeriodic()) { // reset periodic time");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("best_task.elapsed_time_ms = 0;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("} else { // remove the task");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("best_task.reset();");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("if (before_best < length) { // remove in list");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("tasks[before_best].next_task_idx = best_task.next_task_idx;");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("} else { // remove head");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("next_active_task = best_task.next_task_idx;");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("best_task.next_task_idx = next_free_task;");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("next_free_task = best;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// execute the task");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("data.execute();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("task_fired = true;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} while (task_fired && next_active_task < length);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("proceeded_time += time_to_proceed;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("time_to_proceed = std::min(time_till_next_task(), elapsed_ms - proceeded_time);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence unsetGenericTimer() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        String _timerServiceImplementation = this._cppNaming.timerServiceImplementation();
        _builder.append(_timerServiceImplementation);
        _builder.append("::unsetGenericTimer(");
        String _timerServiceImplementationTask = this._cppNaming.timerServiceImplementationTask();
        _builder.append(_timerServiceImplementationTask);
        _builder.append("::TimerTaskMatcher &matcher) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("size_t last_position = length;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("size_t next_position = next_active_task;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("while (next_position < length) {");
        _builder.newLine();
        _builder.append("\t\t");
        String _timerServiceImplementationTask_1 = this._cppNaming.timerServiceImplementationTask();
        _builder.append(_timerServiceImplementationTask_1, "\t\t");
        _builder.append(" &current_task = tasks[next_position];");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if (matcher.match(current_task)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("current_task.reset();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (last_position < length) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("tasks[last_position].next_task_idx = current_task.next_task_idx;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("next_active_task = current_task.next_task_idx;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("size_t current_position = next_position;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("next_position = current_task.next_task_idx;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("current_task.next_task_idx = next_free_task;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("next_free_task = current_position;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("last_position = next_position;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("next_position = current_task.next_task_idx;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence unsetTimer() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*! Unset the given time event.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("void ");
        String _timerServiceImplementation = this._cppNaming.timerServiceImplementation();
        _builder.append(_timerServiceImplementation);
        _builder.append("::unsetTimer(");
        CharSequence _sharedPtr = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr);
        _builder.append("TimedInterface ");
        CharSequence _pointerType = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType);
        _builder.append("statemachine, ");
        String _fqName = this._cppTypes.sc_eventid().fqName();
        _builder.append(_fqName);
        _builder.append(" event) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _timerServiceImplementationTask = this._cppNaming.timerServiceImplementationTask();
        _builder.append(_timerServiceImplementationTask, "\t");
        _builder.append("::MatchTimeEvent matcher(statemachine, event);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("unsetGenericTimer(matcher);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence setGenericTimer() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        String _timerServiceImplementation = this._cppNaming.timerServiceImplementation();
        _builder.append(_timerServiceImplementation);
        _builder.append("::setGenericTimer(const ");
        String _timerServiceImplementationTask = this._cppNaming.timerServiceImplementationTask();
        _builder.append(_timerServiceImplementationTask);
        _builder.append("::TaskData &data) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("// do nothing if there are no free slots");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (next_free_task >= length) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Insert the task at the front");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("size_t inserted_task_idx = next_free_task;");
        _builder.newLine();
        _builder.append("\t");
        String _timerServiceImplementationTask_1 = this._cppNaming.timerServiceImplementationTask();
        _builder.append(_timerServiceImplementationTask_1, "\t");
        _builder.append(" &inserted_task = tasks[inserted_task_idx];");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("inserted_task.data = data;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("next_free_task = inserted_task.next_task_idx;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("inserted_task.next_task_idx = next_active_task;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("next_active_task = inserted_task_idx;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence setTimer() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*! Start the timing for a time event.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("void ");
        String _timerServiceImplementation = this._cppNaming.timerServiceImplementation();
        _builder.append(_timerServiceImplementation);
        _builder.append("::setTimer(");
        CharSequence _sharedPtr = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr);
        _builder.append("TimedInterface ");
        CharSequence _pointerType = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType);
        _builder.append("statemachine, ");
        String _fqName = this._cppTypes.sc_eventid().fqName();
        _builder.append(_fqName);
        _builder.append(" event,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _fqName_1 = this._cppTypes.sc_time().fqName();
        _builder.append(_fqName_1, "\t\t");
        _builder.append(" time_ms, ");
        String _fqName_2 = this._cppTypes.sc_bool().fqName();
        _builder.append(_fqName_2, "\t\t");
        _builder.append(" isPeriodic) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _timerServiceImplementationTask = this._cppNaming.timerServiceImplementationTask();
        _builder.append(_timerServiceImplementationTask, "\t");
        _builder.append("::TaskData data(statemachine, event, time_ms, isPeriodic);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("setGenericTimer(data);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence setRuncycleTimerFor() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*! Set a timer for running cycles of the given statemachine.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("void ");
        String _timerServiceImplementation = this._cppNaming.timerServiceImplementation();
        _builder.append(_timerServiceImplementation);
        _builder.append("::setRuncycleTimerFor(");
        CharSequence _sharedPtr = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr);
        String _cycleBasedInterface = this._cppNaming.cycleBasedInterface();
        _builder.append(_cycleBasedInterface);
        _builder.append(" ");
        CharSequence _pointerType = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType);
        _builder.append("statemachine,  ");
        String _fqName = this._cppTypes.sc_time().fqName();
        _builder.append(_fqName);
        _builder.append(" cycle_period) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _timerServiceImplementationTask = this._cppNaming.timerServiceImplementationTask();
        _builder.append(_timerServiceImplementationTask, "\t");
        _builder.append("::TaskData data(statemachine, cycle_period);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("setGenericTimer(data);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence unsetRuncycleTimerFor() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*! Unset timers for running cycles of the given statemachine.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("void ");
        String _timerServiceImplementation = this._cppNaming.timerServiceImplementation();
        _builder.append(_timerServiceImplementation);
        _builder.append("::unsetRuncycleTimerFor(");
        CharSequence _sharedPtr = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr);
        String _cycleBasedInterface = this._cppNaming.cycleBasedInterface();
        _builder.append(_cycleBasedInterface);
        _builder.append(" ");
        CharSequence _pointerType = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType);
        _builder.append("statemachine) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _timerServiceImplementationTask = this._cppNaming.timerServiceImplementationTask();
        _builder.append(_timerServiceImplementationTask, "\t");
        _builder.append("::MatchRunCycleOf matcher(statemachine);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("unsetGenericTimer(matcher);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence timeTillNextTask() {
        StringConcatenation _builder = new StringConcatenation();
        String _fqName = this._cppTypes.sc_time().fqName();
        _builder.append(_fqName);
        _builder.append(" ");
        String _timerServiceImplementation = this._cppNaming.timerServiceImplementation();
        _builder.append(_timerServiceImplementation);
        _builder.append("::time_till_next_task() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (next_active_task == length) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        String _fqName_1 = this._cppTypes.sc_time().fqName();
        _builder.append(_fqName_1, "\t");
        _builder.append(" time = tasks[next_active_task].data.get.time_ms - tasks[next_active_task].elapsed_time_ms;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("size_t task = tasks[next_active_task].next_task_idx;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("while (task < length) {");
        _builder.newLine();
        _builder.append("\t\t");
        String _timerServiceImplementationTask = this._cppNaming.timerServiceImplementationTask();
        _builder.append(_timerServiceImplementationTask, "\t\t");
        _builder.append(" &current_task = tasks[task]; ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _fqName_2 = this._cppTypes.sc_time().fqName();
        _builder.append(_fqName_2, "\t\t");
        _builder.append(" remaining_time = current_task.data.get.time_ms - current_task.elapsed_time_ms;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if (remaining_time < time) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("time = remaining_time;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task = current_task.next_task_idx; ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return time;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

