/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.simpleconfigurator.manipulator.SimpleConfiguratorManipulator;
import org.eclipse.jdt.internal.junit.JUnitCorePlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

class P2Utils {
    public static BundleInfo findBundle(String symbolicName, Version version, boolean isSourceBundle) {
        Assert.isLegal((symbolicName != null ? 1 : 0) != 0);
        Assert.isLegal((version != null ? 1 : 0) != 0);
        return P2Utils.findBundle(symbolicName, new VersionRange('[', version, version, ']'), isSourceBundle);
    }

    public static BundleInfo findBundle(String symbolicName, VersionRange versionRange, boolean isSourceBundle) {
        Assert.isLegal((symbolicName != null ? 1 : 0) != 0);
        Assert.isLegal((versionRange != null ? 1 : 0) != 0);
        SimpleConfiguratorManipulator manipulator = (SimpleConfiguratorManipulator)JUnitCorePlugin.getDefault().getService(SimpleConfiguratorManipulator.class.getName());
        if (manipulator == null) {
            return null;
        }
        BundleInfo bestMatch = null;
        Version bestVersion = null;
        String bundleInfoPath = null;
        if (isSourceBundle) {
            bundleInfoPath = SimpleConfiguratorManipulator.SOURCE_INFO;
        }
        BundleContext context = JUnitCorePlugin.getDefault().getBundle().getBundleContext();
        BundleInfo[] bundles = null;
        try {
            bundles = manipulator.loadConfiguration(context, bundleInfoPath);
        }
        catch (IOException e) {
            JUnitCorePlugin.log(e);
        }
        if (bundles != null) {
            BundleInfo[] bundleInfoArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Version version;
                BundleInfo bundleInfo = bundleInfoArray[n2];
                if (symbolicName.equals(bundleInfo.getSymbolicName()) && versionRange.includes(version = new Version(bundleInfo.getVersion()))) {
                    IPath path = P2Utils.getBundleLocationPath(bundleInfo);
                    if ((bestVersion == null || bestVersion.compareTo(version) < 0) && path != null && path.toFile().exists()) {
                        bestMatch = bundleInfo;
                        bestVersion = version;
                    }
                }
                ++n2;
            }
        }
        return bestMatch;
    }

    public static IPath getBundleLocationPath(BundleInfo bundleInfo) {
        if (bundleInfo == null) {
            return null;
        }
        URI bundleLocation = bundleInfo.getLocation();
        if (bundleLocation == null) {
            return null;
        }
        try {
            URL localFileURL = FileLocator.toFileURL((URL)URIUtil.toURL((URI)bundleLocation));
            URI localFileURI = new URI(localFileURL.toExternalForm());
            return new Path(localFileURI.getPath());
        }
        catch (IOException | URISyntaxException e) {
            JUnitCorePlugin.log(e);
            return null;
        }
    }

    private P2Utils() {
    }
}

