/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.commons;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;

public class PathHelper {
    public String toPathString(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return file.getAbsolutePath();
        }
    }

    public Path toPath(String pathString, LinkOption ... options) {
        if (pathString == null) {
            return null;
        }
        Path path = Paths.get(pathString, new String[0]);
        try {
            return path.toRealPath(options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return path;
        }
    }

    public Path toPath(URI uri, LinkOption ... options) {
        return this.toPath(uri.toFileString(), options);
    }

    public Path toPath(IResource file, LinkOption ... options) {
        return this.toPath(file.getLocation().toOSString(), options);
    }

    public boolean pathsEqual(String p1, String p2) {
        Path path1 = this.toPath(p1, new LinkOption[0]);
        Path path2 = this.toPath(p2, new LinkOption[0]);
        return this.pathsEqual(path1, path2);
    }

    public boolean pathsEqual(Path p1, Path p2) {
        return Objects.equals(p1, p2);
    }
}

