/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.genmodel.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.yakindu.base.expressions.expressions.ExpressionsPackage;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.TypesPackage;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.generator.core.extensions.GeneratorExtensions;
import com.yakindu.sct.generator.core.extensions.IGeneratorDescriptor;
import com.yakindu.sct.generator.core.extensions.ILibraryDescriptor;
import com.yakindu.sct.generator.core.extensions.LibraryExtensions;
import com.yakindu.sct.generator.genmodel.ext.FeatureTypeLibraryExportAnalyzer;
import com.yakindu.sct.generator.genmodel.typesystem.BuiltinDeclarations;
import com.yakindu.sct.model.sgen.FeatureConfiguration;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgen.GeneratorModel;
import com.yakindu.sct.model.sgen.SGenPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class SGenScopeProvider
extends AbstractDeclarativeScopeProvider {
    @Inject
    private Injector injector;
    @Inject
    private ITypeSystem typeSystem;
    @Inject
    private BuiltinDeclarations buildInDeclarations;

    public IScope getScope(EObject context, EReference reference) {
        if (reference == TypesPackage.Literals.TYPE_SPECIFIER__TYPE) {
            return Scopes.scopeFor((Iterable)this.typeSystem.getConcreteTypes());
        }
        if (reference == ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE) {
            return this.getElementReferenceScope(context);
        }
        boolean _equals = reference.getName().equals("type");
        if (_equals) {
            return this.scope_Type(context, reference);
        }
        boolean _equals_1 = reference.getName().equals("parameter");
        if (_equals_1) {
            return this.scope_Parameter(context, reference);
        }
        boolean _equals_2 = reference.getName().equals("elementRef");
        if (_equals_2) {
            return this.scope_GeneratorEntry_elementRef(context, reference);
        }
        return super.getScope(context, reference);
    }

    protected IScope getElementReferenceScope(EObject context) {
        boolean _tripleNotEquals;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)context);
        GeneratorModel generatorModel = (GeneratorModel)_rootContainer;
        EList properties = generatorModel.getProperties();
        ArrayList all = Lists.newArrayList();
        List<Property> _globalDeclarations = this.buildInDeclarations.getGlobalDeclarations();
        Iterables.addAll((Collection)all, _globalDeclarations);
        GeneratorEntry _containerOfType = (GeneratorEntry)EcoreUtil2.getContainerOfType((EObject)context, GeneratorEntry.class);
        boolean bl = _tripleNotEquals = _containerOfType != null;
        if (_tripleNotEquals) {
            List<Property> _statechartLocalDeclarations = this.buildInDeclarations.getStatechartLocalDeclarations();
            Iterables.addAll((Collection)all, _statechartLocalDeclarations);
        }
        return Scopes.scopeFor((Iterable)properties, (IScope)Scopes.scopeFor((Iterable)all));
    }

    protected IScope scope_GeneratorEntry_elementRef(EObject context, EReference reference) {
        boolean _not;
        EObject _rootContainer = EcoreUtil2.getRootContainer((EObject)context);
        GeneratorModel generatorModel = (GeneratorModel)_rootContainer;
        String id = generatorModel.getGeneratorId();
        Optional desc = GeneratorExtensions.getGeneratorDescriptor((String)id);
        boolean _isPresent = desc.isPresent();
        boolean bl = _not = !_isPresent;
        if (_not) {
            return IScope.NULLSCOPE;
        }
        String elementRefType = ((IGeneratorDescriptor)desc.get()).getElementRefType();
        IScope _scope = this.getDelegate().getScope(context, reference);
        Predicate _function = input -> {
            EList allSuperTypes = input.getEClass().getESuperTypes();
            for (EClass eClass : allSuperTypes) {
                boolean _equals = elementRefType.equals(eClass.getInstanceClassName());
                if (!_equals) continue;
                return true;
            }
            return elementRefType.equals(input.getEClass().getInstanceClassName());
        };
        FilteringScope scope = new FilteringScope(_scope, _function);
        Iterable _allElements = scope.getAllElements();
        return new SimpleScope(_allElements);
    }

    protected IScope scope_Parameter(EObject context, EReference reference) {
        SimpleScope libraryScope = this.getLibraryScope(context.eResource());
        Predicate _function = input -> {
            boolean _not;
            boolean _equals = input.getEClass().equals(SGenPackage.Literals.FEATURE_PARAMETER);
            boolean bl = _not = !_equals;
            if (_not) {
                return false;
            }
            FeatureConfiguration configuration = (FeatureConfiguration)EcoreUtil2.getContainerOfType((EObject)context, FeatureConfiguration.class);
            if (configuration == null || configuration.getType() == null) {
                return false;
            }
            String featureName = configuration.getType().getName();
            if (featureName == null) {
                return false;
            }
            return featureName.equals(input.getUserData("featureContainer"));
        };
        return new FilteringScope((IScope)libraryScope, _function);
    }

    protected IScope scope_Type(EObject context, EReference reference) {
        SimpleScope libraryScope = this.getLibraryScope(context.eResource());
        Predicate _function = input -> input.getEClass().equals(SGenPackage.Literals.FEATURE_TYPE);
        return new FilteringScope((IScope)libraryScope, _function);
    }

    protected SimpleScope getLibraryScope(Resource resource) {
        Object _objectByType = EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SGenPackage.Literals.GENERATOR_MODEL);
        GeneratorModel generatorModel = (GeneratorModel)_objectByType;
        Assert.isNotNull((Object)generatorModel);
        String generatorId = generatorModel.getGeneratorId();
        ArrayList allElements = Lists.newArrayList();
        Optional generatorDescriptor = GeneratorExtensions.getGeneratorDescriptor((String)generatorId);
        boolean _isPresent = generatorDescriptor.isPresent();
        if (_isPresent) {
            ILibraryDescriptor libraryDescriptor = LibraryExtensions.getLibraryDescriptor((String)((IGeneratorDescriptor)generatorDescriptor.get()).getLibraryID());
            FeatureTypeLibrary _featureTypeLibrary = libraryDescriptor.getFeatureTypeLibrary();
            FeatureTypeLibraryExportAnalyzer analyzer = new FeatureTypeLibraryExportAnalyzer(_featureTypeLibrary);
            this.injector.injectMembers((Object)analyzer);
            List<IEObjectDescription> _computeExportedObjects = analyzer.computeExportedObjects();
            Iterables.addAll((Collection)allElements, _computeExportedObjects);
        }
        return new SimpleScope((Iterable)allElements);
    }
}

