/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.base.BasePackage;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.AnnotatableElement;
import com.yakindu.base.types.Annotation;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeBuilder;
import com.yakindu.base.types.TypeParameter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@Singleton
public class TypesUtil {
    @Inject
    @Extension
    protected TypeBuilder _typeBuilder;
    public static final String ID_SEPARATOR = ".";
    public static final String SOURCE_TYPE = "__source_type__";

    public <T extends AnnotatableElement> T _source_type(T e) {
        return this._typeBuilder._annotate(e, SOURCE_TYPE, new Expression[0]);
    }

    public boolean isSource_type(AnnotatableElement it) {
        boolean _tripleNotEquals;
        boolean _xifexpression = false;
        Annotation _annotationOfType = it.getAnnotationOfType(SOURCE_TYPE);
        boolean bl = _tripleNotEquals = _annotationOfType != null;
        if (_tripleNotEquals) {
            return true;
        }
        _xifexpression = false;
        return _xifexpression;
    }

    public static String computeQID(NamedElement element) {
        boolean _tripleEquals;
        String _name = element.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return null;
        }
        StringBuilder id = new StringBuilder();
        id.append(element.getName());
        EObject container = element.eContainer();
        while (container != null) {
            boolean _contains = container.eClass().getEAllStructuralFeatures().contains((Object)BasePackage.Literals.NAMED_ELEMENT__NAME);
            if (_contains) {
                TypesUtil.prependNamedElementName(id, container);
            } else {
                TypesUtil.prependContainingFeatureName(id, container);
            }
            container = container.eContainer();
        }
        return id.toString();
    }

    private static void prependNamedElementName(StringBuilder id, EObject container) {
        Object _eGet = container.eGet((EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
        String name = (String)_eGet;
        if (name != null) {
            id.insert(0, ID_SEPARATOR);
            id.insert(0, name);
        }
    }

    private static void prependContainingFeatureName(StringBuilder id, EObject container) {
        EStructuralFeature feature = container.eContainingFeature();
        if (feature != null) {
            Object name = null;
            boolean _isMany = feature.isMany();
            if (_isMany) {
                Object elements = container.eContainer().eGet(feature);
                int index = 0;
                if (elements instanceof BasicEList) {
                    BasicEList elementList = (BasicEList)elements;
                    index = elementList.indexOf((Object)container);
                }
                String _name = feature.getName();
                String _plus = _name + String.valueOf((Object)index);
                name = _plus;
            } else {
                name = feature.getName();
            }
            id.insert(0, ID_SEPARATOR);
            id.insert(0, (String)name);
        }
    }

    protected static QualifiedName _toQualifiedName(TypeParameter tp) {
        return QualifiedName.create((String)tp.getName());
    }

    protected static QualifiedName _toQualifiedName(Type t) {
        Functions.Function1 _function = p -> {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)p.getName());
            return !_isNullOrEmpty;
        };
        Functions.Function1 _function_1 = it -> it.getName();
        List names = ListExtensions.reverse((List)IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)EcoreUtil2.getAllContainers((EObject)t), Type.class), (Functions.Function1)_function), (Functions.Function1)_function_1)));
        String _name = t.getName();
        names.add(_name);
        return QualifiedName.create((List)names);
    }

    protected static QualifiedName _toQualifiedName(ComplexType t) {
        Functions.Function1 _function = p -> {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)p.getName());
            return !_isNullOrEmpty;
        };
        Functions.Function1 _function_1 = it -> it.getName();
        List names = ListExtensions.reverse((List)IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)EcoreUtil2.getAllContainers((EObject)t), Package.class), (Functions.Function1)_function), (Functions.Function1)_function_1)));
        String _name = t.getName();
        names.add(_name);
        return QualifiedName.create((List)names);
    }

    protected static QualifiedName _toQualifiedName(EObject t) {
        throw new IllegalArgumentException("Could not create qualified name for " + String.valueOf(t));
    }

    public static Set<Type> collectPackageContainedTypes(Package pckg, Set<Type> types) {
        Set<Type> _xblockexpression = null;
        if (pckg != null) {
            Consumer<Declaration> _function = it -> {
                if (it instanceof Package) {
                    TypesUtil.collectPackageContainedTypes((Package)it, types);
                } else if (it instanceof Type) {
                    types.add((Type)it);
                }
            };
            pckg.getMember().forEach(_function);
        }
        _xblockexpression = types;
        return _xblockexpression;
    }

    public <T> T lastOrNull(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            boolean _isEmpty = list.isEmpty();
            if (_isEmpty) {
                return null;
            }
            int _size = list.size();
            int _minus = _size - 1;
            return (T)list.get(_minus);
        }
        if (iterable instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)iterable;
            boolean _isEmpty_1 = sortedSet.isEmpty();
            if (_isEmpty_1) {
                return null;
            }
            return (T)sortedSet.last();
        }
        return this.lastOrNull(iterable.iterator());
    }

    public <T> T lastOrNull(Iterator<T> iterator) {
        T result = null;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    @XbaseGenerated
    public static QualifiedName toQualifiedName(EObject t) {
        if (t instanceof ComplexType) {
            return TypesUtil._toQualifiedName((ComplexType)t);
        }
        if (t instanceof TypeParameter) {
            return TypesUtil._toQualifiedName((TypeParameter)t);
        }
        if (t instanceof Type) {
            return TypesUtil._toQualifiedName((Type)t);
        }
        if (t != null) {
            return TypesUtil._toQualifiedName(t);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t).toString());
    }
}

